/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import journeymap.api.services.Services;
import journeymap.common.nbt.model.PlayerDTO;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;

public class PlayerData
extends class_18 {
    private static final Codec<PlayerDTO> PLAYEER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("player_id").forGetter(PlayerDTO::getUuid), (App)Codec.BOOL.fieldOf("hidden_underground").forGetter(PlayerDTO::isHiddenUnderground), (App)Codec.BOOL.fieldOf("radar_visible").forGetter(PlayerDTO::isVisible), (App)Codec.BOOL.fieldOf("view_loaded_chunk_entity").forGetter(PlayerDTO::isChunkEntity), (App)Codec.BOOL.fieldOf("view_loaded_chunk_full").forGetter(PlayerDTO::isChunkFull), (App)Codec.BOOL.fieldOf("view_loaded_chunk_block").forGetter(PlayerDTO::isChunkBlock), (App)Codec.BOOL.fieldOf("view_loaded_chunk_inaccessible").forGetter(PlayerDTO::isChunkInaccessible)).apply((Applicative)instance, PlayerDTO::new));
    private static final Codec<Map<String, PlayerDTO>> CODEC_LIST = Codec.unboundedMap((Codec)Codec.STRING, PLAYEER_CODEC);
    private static final Codec<PlayerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC_LIST.fieldOf("players").forGetter(p -> p.playerMap)).apply((Applicative)instance, map -> new PlayerData(new HashMap<String, PlayerDTO>((Map<String, PlayerDTO>)map))));
    private static final class_10741<PlayerData> TYPE = new class_10741("JMPlayerSettings", PlayerData::new, CODEC, class_4284.field_19216);
    private final Map<String, PlayerDTO> playerMap;

    public PlayerData(Map<String, PlayerDTO> playerMap) {
        this.playerMap = playerMap;
        Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179).method_17983().method_123(TYPE, (class_18)this);
    }

    public PlayerData() {
        this(new HashMap<String, PlayerDTO>());
        this.method_80();
    }

    public static PlayerData getPlayerData() {
        return PlayerData.get();
    }

    private static PlayerData get() {
        class_3218 level = Services.COMMON_SERVICE.getServer().method_3847(class_1937.field_25179);
        return (PlayerData)level.method_17983().method_17924(TYPE);
    }

    public PlayerDTO getPlayer(class_3222 serverPlayer) {
        String uuid = serverPlayer.method_5845();
        return this.playerMap.computeIfAbsent(uuid, PlayerDTO::new);
    }
}

