/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.event.handlers.EntityRadarUpdateEventHandler;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.EntityDisplay;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;

public class DrawEntityStep
implements DrawStep {
    static final Integer labelBg = 0;
    static final float labelBgAlpha = 0.7f;
    static final Integer labelFg = 0xFFFFFF;
    static final float labelFgAlpha = 0.88f;
    static class_2960 playerOutlineTexture;
    boolean useDots;
    int elevationOffset;
    int color;
    int labelColor;
    boolean hideSneaks;
    boolean hideSpectators;
    boolean showHeading = true;
    boolean showOutline = false;
    class_310 minecraft = class_310.method_1551();
    class_2960 entityTexture;
    class_2960 locatorTexture;
    class_2960 locatorBGTexture;
    WeakReference<class_1309> entityRef;
    class_2561 customName;
    class_2561 playerTeamName;
    Point2D screenPosition;
    EntityDTO entityDTO;
    float drawScale = 1.0f;
    private boolean showTeamName;
    private boolean showPlayerName;

    private DrawEntityStep(class_1309 entityLiving) {
        this.entityRef = new WeakReference<class_1309>(entityLiving);
        this.hideSneaks = JourneymapClient.getInstance().getCoreProperties().hideSneakingEntities.get();
        this.hideSpectators = JourneymapClient.getInstance().getCoreProperties().hideSpectators.get();
        if (playerOutlineTexture == null) {
            playerOutlineTexture = TextureCache.PlayerOutline;
        }
    }

    public void update(EntityDisplay entityDisplay, class_2960 locatorTexture, class_2960 locatorBGTexture, class_2960 entityTexture, int color, int labelColor, boolean showHeading, boolean showTeamName, boolean showPlayerName, boolean showOutline, float entityDrawScale) {
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        this.entityDTO = DataCache.INSTANCE.getEntityDTO(entityLiving);
        if (entityLiving != null) {
            this.customName = this.entityDTO.getCustomName();
        }
        this.useDots = entityDisplay.isDots();
        this.color = color;
        this.labelColor = labelColor;
        this.locatorTexture = locatorTexture;
        this.locatorBGTexture = locatorBGTexture;
        this.entityTexture = entityTexture;
        this.drawScale = entityDrawScale;
        this.showHeading = showHeading;
        this.showTeamName = showTeamName;
        this.showPlayerName = showPlayerName;
        this.showOutline = showOutline;
        if (entityLiving instanceof class_1657) {
            class_268 team = entityLiving.method_5781();
            this.playerTeamName = team != null && showTeamName ? class_268.method_1142((class_270)entityLiving.method_5781(), (class_2561)entityLiving.method_5477()) : null;
        }
    }

    @Override
    public void draw(class_332 graphics, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (entityLiving == null || !entityLiving.method_5805() || entityLiving.method_5756((class_1657)this.minecraft.field_1724) || this.hideSneaks && entityLiving.method_5715() || this.hideSpectators && entityLiving.method_7325()) {
            this.screenPosition = null;
            return;
        }
        this.screenPosition = renderer.getPixel(entityLiving.method_23317(), entityLiving.method_23321());
        if (this.screenPosition != null) {
            double heading = entityLiving.method_36454();
            double drawX = this.screenPosition.getX() + xOffset;
            double drawY = this.screenPosition.getY() + yOffset;
            float alpha = 1.0f;
            if (entityLiving.method_23318() > this.minecraft.field_1724.method_23318()) {
                alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.method_23318() - this.minecraft.field_1724.method_23318()) / 32.0));
            } else if (entityLiving.method_23318() < this.minecraft.field_1724.method_23318()) {
                alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.field_1724.method_23318() - entityLiving.method_23318()) / 32.0));
            }
            if (entityLiving instanceof class_1657) {
                alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                this.drawPlayer(graphics, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            } else {
                alpha = JourneymapClient.getInstance().getCoreProperties().mobIconFade.get() != false ? alpha : 1.0f;
                this.drawCreature(graphics, drawX, drawY, renderer, alpha, heading, fontScale, rotation);
            }
        }
    }

    private void drawEntityTooltip(class_332 graphics, Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        boolean specialDebug;
        if (renderer.getFullscreen() != null && this.entityDTO != null && this.entityDTO.getEntityToolTips() != null && this.isMouseOverEntity(renderer, drawX, drawY, imageWidth, imageHeight)) {
            renderer.getFullscreen().queueToolTip(this.entityDTO.getEntityToolTips());
        }
        if (specialDebug = false) {
            double thick = 2.0;
            double x = drawX - (double)(imageWidth / 2);
            double y = drawY - (double)(imageHeight / 2);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick * thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y - thick, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth, y, thick, imageHeight, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x + (double)imageWidth + thick, y - thick, thick, (double)imageHeight + thick * thick, 0, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick, y + (double)imageHeight, (double)imageWidth + thick * thick, thick, 0xFFFFFF, 0.6f);
            DrawUtil.drawRectangle(graphics, x - thick * thick, y + (double)imageHeight + thick, (double)imageWidth + thick * 4.0, thick, 0, 0.6f);
        }
    }

    private boolean isMouseOverEntity(Renderer renderer, double drawX, double drawY, int imageWidth, int imageHeight) {
        double mouseX = (double)renderer.getMouseX() * renderer.getFullscreen().getScreenScaleFactor();
        double mouseY = (double)renderer.getMouseY() * renderer.getFullscreen().getScreenScaleFactor();
        double x = drawX - (double)(imageWidth / 2);
        double y = drawY - (double)(imageHeight / 2);
        return mouseX >= x && mouseX <= x + (double)imageWidth && mouseY >= y && mouseY <= y + (double)imageHeight;
    }

    private void drawPlayer(class_332 graphics, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        boolean drawingIcon;
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        boolean bl = drawingIcon = this.entityTexture != null && !this.useDots;
        if (this.locatorTexture != null && !drawingIcon) {
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
            this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
        }
        if (this.entityTexture != null) {
            if (this.useDots) {
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.method_23318());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    boolean flip = this.elevationOffset < -1;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, flip ? -rotation + 180.0 : -rotation);
                    this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
                }
            } else {
                float locatorScale = this.drawScale * 1.5f;
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorBGTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, 24.0, 24.0, this.drawScale, rotation);
                if (this.showOutline) {
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, playerOutlineTexture, this.color, alpha, drawX, drawY, 26.0, 25.0, this.drawScale, rotation);
                }
                if (this.locatorTexture != null) {
                    int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, locatorColor, alpha, drawX, drawY, 160.0, 160.0, locatorScale / 5.0f, this.showHeading ? -heading : rotation);
                }
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, 16, 16);
            }
        }
        if (JourneymapClient.getInstance().getStateHandler().isPlayerRadarNamesEnabled()) {
            double labelOffset = this.entityTexture == null ? 0.0 : 13.0;
            labelOffset = labelOffset * (double)this.drawScale * (drawingIcon ? 1.0 : 0.6);
            Point2D labelPoint = renderer.shiftWindowPosition(drawX, drawY, 0, (int)(labelOffset += fontScale * 5.0));
            if (this.playerTeamName != null && this.showTeamName) {
                DrawUtil.drawLabel(graphics, this.playerTeamName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            } else if (this.showPlayerName) {
                class_2561 playerName = this.customName != null ? this.customName : entityLiving.method_5477();
                DrawUtil.drawLabel(graphics, playerName, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.8f, this.labelColor, 1.0f, fontScale, false, rotation);
            }
        }
    }

    private void drawCreature(class_332 graphics, double drawX, double drawY, Renderer renderer, float alpha, double heading, double fontScale, double rotation) {
        class_2561 name;
        boolean drawingIcon;
        boolean tabDown = class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)258) && (class_310.method_1551().field_1755 == null || class_310.method_1551().field_1755 instanceof Fullscreen);
        class_1309 entityLiving = (class_1309)this.entityRef.get();
        if (entityLiving == null) {
            return;
        }
        boolean bl = drawingIcon = this.entityTexture != null && (!this.useDots || tabDown && EntityDisplay.hasEntityIcon(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO));
        if (this.locatorTexture != null && !drawingIcon) {
            DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
            this.drawEntityTooltip(graphics, renderer, drawX, drawY, (int)(3.0f * (this.drawScale / 2.0f)), (int)(3.0f * (this.drawScale / 2.0f)));
        }
        if (this.entityTexture != null) {
            if (!drawingIcon) {
                this.elevationOffset = (int)(DataCache.getPlayer().posY - entityLiving.method_23318());
                if (this.elevationOffset < -1 || this.elevationOffset > 1) {
                    boolean flip = this.elevationOffset < -1;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, flip ? rotation + 180.0 : rotation);
                    this.drawEntityTooltip(graphics, renderer, drawX, drawY, 3, 3);
                }
            } else {
                class_2960 locBGTexTemp = this.locatorBGTexture;
                class_2960 entityTexTemp = this.entityTexture;
                class_2960 locTexTemp = this.locatorTexture;
                if (this.useDots) {
                    class_2960 quickTexture = EntityDisplay.getLocatorBGTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                    this.locatorBGTexture = quickTexture != null ? quickTexture : this.locatorBGTexture;
                    quickTexture = EntityDisplay.getEntityTexture(EntityDisplay.DotsAndOutlinedIcons, this.entityDTO);
                    this.entityTexture = quickTexture != null ? quickTexture : this.entityTexture;
                    quickTexture = EntityDisplay.getLocatorTexture(EntityDisplay.DotsAndOutlinedIcons, this.showHeading);
                    class_2960 class_29602 = this.locatorTexture = quickTexture != null ? quickTexture : this.locatorTexture;
                }
                if (this.locatorBGTexture != null) {
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorBGTexture, this.color, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation);
                }
                if (this.entityTexture != null) {
                    class_1044 texture = TextureCache.getTexture(this.entityTexture);
                    int width = texture.method_68004().getWidth(0);
                    int height = texture.method_68004().getHeight(0);
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.entityTexture, 0xFFFFFF, alpha, drawX, drawY, width, height, this.drawScale, rotation);
                }
                if (this.locatorTexture != null && (!this.entityDTO.hasCustomIcon || this.entityDTO.drawOutline)) {
                    int locatorColor = this.entityDTO.getAggro() != false ? 0xFF0000 : 0;
                    DrawUtil.drawOnMapImageScaleCorrected(graphics, this.locatorTexture, locatorColor, alpha, drawX, drawY, 160.0, 160.0, this.drawScale / 5.0f, this.showHeading ? -heading : -rotation, true);
                }
                this.drawEntityTooltip(graphics, renderer, drawX, drawY, 16, 16);
                if (this.useDots) {
                    this.locatorBGTexture = locBGTexTemp;
                    this.entityTexture = entityTexTemp;
                    this.locatorTexture = locTexTemp;
                }
            }
        }
        if ((name = this.customName) == null && tabDown) {
            name = EntityRadarUpdateEventHandler.getEntityName(this.entityDTO, renderer.getUIState(), true);
            EntityRadarUpdateEventHandler.addEntityToolTips(this.entityDTO, renderer.getUIState(), name, true);
        }
        if (name != null) {
            double labelOffset = (double)(13.0f * this.drawScale) * (drawingIcon ? 1.0 : 0.6);
            Point2D labelPoint = renderer.shiftWindowPosition(drawX, drawY, 0, (int)(labelOffset += fontScale * 10.0));
            int color = name.method_10866().method_10973() != null ? name.method_10866().method_10973().method_27716() : 0xFFFFFF;
            DrawUtil.drawLabel(graphics, name, labelPoint.getX(), labelPoint.getY(), DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, labelBg, alpha, color, alpha, fontScale, false, rotation);
        }
    }

    public Point2D.Double getPosition(double xOffset, double yOffset, Renderer renderer, boolean forceUpdate) {
        double x = this.entityDTO.posX;
        double z = this.entityDTO.posZ;
        double halfBlock = renderer.getUIState().blockSize / 2.0;
        Point2D.Double pixel = renderer.getBlockPixelInGrid(x, z);
        pixel.setLocation(pixel.getX() + halfBlock + xOffset, pixel.getY() + halfBlock + yOffset);
        return pixel;
    }

    public void drawOffscreen(class_332 graphics, Point2D pixel, Renderer renderer, double rotation) {
        this.drawOffscreen(graphics, pixel, renderer, rotation, false);
    }

    public void drawOffscreen(class_332 graphics, Point2D pixel, Renderer renderer, double rotation, boolean zeroOffset) {
        Object t = this.entityRef.get();
        if (t instanceof class_1657) {
            class_1657 entityLiving = (class_1657)t;
            if (JourneymapClient.getInstance().getActiveMiniMapProperties().showOffScreenPlayers.get().booleanValue()) {
                double heading = entityLiving.method_36454();
                float alpha = 1.0f;
                if (entityLiving.method_23318() > this.minecraft.field_1724.method_23318()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((entityLiving.method_23318() - this.minecraft.field_1724.method_23318()) / 32.0));
                } else if (entityLiving.method_23318() < this.minecraft.field_1724.method_23318()) {
                    alpha = 1.0f - Math.max(0.1f, (float)((this.minecraft.field_1724.method_23318() - entityLiving.method_23318()) / 32.0));
                }
                float texOffsetX = 8.0f * (this.drawScale * 0.5f);
                float texOffsetY = 8.0f * (this.drawScale * 0.5f);
                if (this.useDots) {
                    texOffsetX *= 0.25f;
                    texOffsetY *= 0.25f;
                }
                if (zeroOffset) {
                    if (pixel.getX() <= 0.0) {
                        texOffsetX = -(texOffsetX * (this.useDots ? 0.25f : 0.5f));
                    }
                    if (pixel.getY() <= 0.0) {
                        texOffsetY = -(texOffsetY * (this.useDots ? 0.25f : 0.5f));
                    }
                }
                if (entityLiving instanceof class_1657) {
                    alpha = JourneymapClient.getInstance().getCoreProperties().playerIconFade.get() != false ? alpha : 1.0f;
                    this.drawPlayer(graphics, pixel.getX() - (double)texOffsetX, pixel.getY() - (double)texOffsetY, renderer, alpha, heading, 1.0, rotation);
                }
            }
        }
    }

    @Override
    public int getDisplayOrder() {
        return this.customName != null ? 1 : 0;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    public static class SimpleCacheLoader
    extends CacheLoader<class_1309, DrawEntityStep> {
        public DrawEntityStep load(class_1309 entityLiving) throws Exception {
            return new DrawEntityStep(entityLiving);
        }
    }
}

