/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.EnumSet;
import journeymap.api.v2.client.display.Context;
import journeymap.client.model.map.MapType;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public enum Feature {
    RadarPlayers,
    RadarAnimals,
    RadarMobs,
    RadarVillagers,
    MapTopo,
    MapSurface,
    MapCaves,
    MapBiome;


    public static EnumSet<Feature> radar() {
        return EnumSet.of(RadarPlayers, RadarAnimals, RadarMobs, RadarVillagers);
    }

    public static EnumSet<Feature> all() {
        return EnumSet.allOf(Feature.class);
    }

    public static Feature fromMapType(MapType mapType) {
        MapType.Name name = mapType.name;
        return switch (name) {
            case MapType.Name.topo -> MapTopo;
            case MapType.Name.underground -> MapCaves;
            case MapType.Name.biome -> MapBiome;
            default -> MapSurface;
        };
    }

    public static Feature fromApiMapType(Context.MapType mapType, class_5321<class_1937> dimension) {
        return Feature.fromMapType(MapType.fromApiContextMapType(mapType, 0, dimension == null ? class_310.method_1551().field_1724.method_73183().method_27983() : dimension));
    }
}

