/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;

public class ModEnchantCommand {
    public static final String KEY_REMOVE_SUCCESS_SINGLE = "commands.enchant.remove.success.single";
    public static final String KEY_REMOVE_SUCCESS_MULTIPLE = "commands.enchant.remove.success.multiple";
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.entity", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.enchant.failed"));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"enchant").requires((Predicate)class_2170.method_71774((class_12090)class_2170.field_31839))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enchantment", (ArgumentType)class_7733.method_45603((class_7157)context, (class_5321)class_7924.field_41265)).executes(commandContext -> ModEnchantCommand.enchant((class_2168)commandContext.getSource(), class_2186.method_9317((CommandContext)commandContext, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)commandContext, (String)"enchantment")))).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(commandContext -> ModEnchantCommand.enchant((class_2168)commandContext.getSource(), class_2186.method_9317((CommandContext)commandContext, (String)"targets"), (class_6880<class_1887>)class_7733.method_45612((CommandContext)commandContext, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level")))))));
    }

    private static int enchant(class_2168 commandSourceStack, Collection<? extends class_1297> collection, class_6880<class_1887> holder) throws CommandSyntaxException {
        return ModEnchantCommand.enchant(commandSourceStack, collection, holder, ((class_1887)holder.comp_349()).method_8183());
    }

    private static int enchant(class_2168 commandSourceStack, Collection<? extends class_1297> entities, class_6880<class_1887> enchantment, int level) throws CommandSyntaxException {
        if (level > 255) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().create((Object)level, (Object)255);
        }
        int successCount = 0;
        for (class_1297 class_12972 : entities) {
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                class_1799 itemStack = livingEntity.method_6047();
                if (!itemStack.method_7960()) {
                    class_9304 itemEnchantments = class_1890.method_57532((class_1799)itemStack);
                    if (level == 0 || (ModEnchantCommand.isBook(itemStack) || ((class_1887)enchantment.comp_349()).method_8192(itemStack)) && ModEnchantCommand.isEnchantmentCompatible(itemEnchantments, enchantment)) {
                        class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
                        if (mutable.method_57546(enchantment) != level) {
                            mutable.method_57547(enchantment, level);
                        } else if (entities.size() == 1) {
                            throw ERROR_NOTHING_HAPPENED.create();
                        }
                        if (itemStack.method_31574(class_1802.field_8529) && !mutable.method_57545().isEmpty()) {
                            itemStack = itemStack.method_56701((class_1935)class_1802.field_8598, 1);
                        }
                        class_1890.method_57530((class_1799)itemStack, (class_9304)mutable.method_57549());
                        if (itemStack.method_31574(class_1802.field_8598) && mutable.method_57545().isEmpty()) {
                            itemStack = itemStack.method_56701((class_1935)class_1802.field_8529, 1);
                        }
                        livingEntity.method_6122(class_1268.field_5808, itemStack);
                        ++successCount;
                        continue;
                    }
                    if (entities.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.method_7909().method_7864(itemStack).getString());
                }
                if (entities.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.method_5477().getString());
            }
            if (entities.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)class_12972.method_5477().getString());
        }
        if (successCount == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (entities.size() == 1) {
            commandSourceStack.method_9226(() -> level > 0 ? class_2561.method_43469((String)"commands.enchant.success.single", (Object[])new Object[]{class_1887.method_8179((class_6880)enchantment, (int)level), ((class_1297)entities.iterator().next()).method_5476()}) : class_2561.method_48322((String)KEY_REMOVE_SUCCESS_SINGLE, (String)"Removed enchantment %s from %s's item", (Object[])new Object[]{ModEnchantCommand.getFullname(enchantment), ((class_1297)entities.iterator().next()).method_5476()}), true);
        } else {
            commandSourceStack.method_9226(() -> level > 0 ? class_2561.method_43469((String)"commands.enchant.success.multiple", (Object[])new Object[]{class_1887.method_8179((class_6880)enchantment, (int)level), entities.size()}) : class_2561.method_48322((String)KEY_REMOVE_SUCCESS_MULTIPLE, (String)"Removed enchantment %s from %s entities", (Object[])new Object[]{ModEnchantCommand.getFullname(enchantment), entities.size()}), true);
        }
        return successCount;
    }

    private static class_2561 getFullname(class_6880<class_1887> enchantment) {
        class_5250 mutableComponent = ((class_1887)enchantment.comp_349()).comp_2686().method_27661();
        if (enchantment.method_40220(class_9636.field_51551)) {
            return mutableComponent.method_27692(class_124.field_1061);
        }
        return mutableComponent.method_27692(class_124.field_1080);
    }

    private static boolean isBook(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_8529) || itemStack.method_31574(class_1802.field_8598);
    }

    private static boolean isEnchantmentCompatible(class_9304 itemEnchantments, class_6880<class_1887> enchantment) {
        class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
        mutable.method_57547(enchantment, 0);
        return class_1890.method_8201((Collection)mutable.method_57545(), enchantment);
    }
}

