/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.init;

import com.mojang.brigadier.arguments.ArgumentType;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import fuzs.puzzleslib.api.init.v3.registry.MenuSupplierWithData;
import fuzs.puzzleslib.impl.init.DirectReferenceHolder;
import fuzs.puzzleslib.impl.init.LazyHolder;
import fuzs.puzzleslib.impl.init.RegistryManagerImpl;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricTrackedDataRegistry;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2941;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public final class FabricRegistryManager
extends RegistryManagerImpl {
    private static final class_5321<class_2378<class_2941<?>>> ENTITY_DATA_SERIALIZERS_REGISTRY_KEY = class_5321.method_29180((class_2960)class_2960.method_60656((String)"entity_data_serializers"));
    private boolean isFrozen;

    public FabricRegistryManager(String modId) {
        super(modId);
    }

    @Override
    public <T> class_6880.class_6883<T> registerLazily(class_5321<? extends class_2378<? super T>> registryKey, String path) {
        this.isWritableOrThrow();
        class_2378 registry = LookupHelper.getRegistry(registryKey).orElseThrow();
        class_5321 resourceKey = this.makeResourceKey(registryKey, path);
        return new LazyHolder(registryKey, resourceKey, () -> {
            class_6880.class_6883 holder = registry.method_46747(resourceKey);
            if (!holder.method_40227()) {
                Object value = registry.method_29107(resourceKey);
                Objects.requireNonNull(value, "value is null");
                holder.method_45918(value);
            }
            return holder;
        });
    }

    @Override
    protected <T> class_6880.class_6883<T> getHolderReference(class_5321<? extends class_2378<? super T>> registryKey, String path, Supplier<T> supplier, boolean skipRegistration) {
        T value = supplier.get();
        Objects.requireNonNull(value, "value is null");
        class_2378 registry = LookupHelper.getRegistry(registryKey).orElseThrow();
        class_6880.class_6883 holder = skipRegistration ? registry.method_46747(this.makeResourceKey(registryKey, path)) : class_2378.method_47985(registry, (class_2960)this.makeKey(path), value);
        if (!holder.method_40227()) {
            holder.method_45918(value);
        }
        return holder;
    }

    @Override
    protected class_1761.class_7913 getCreativeModeTabBuilder(boolean withSearchBar) {
        return FabricItemGroup.builder();
    }

    @Override
    public <T extends class_2586> class_6880.class_6883<class_2591<T>> registerBlockEntityType(String path, BiFunction<class_2338, class_2680, T> blockEntityFactory, Supplier<Set<class_2248>> validBlocks) {
        return this.register(class_7924.field_41255, path, () -> FabricBlockEntityTypeBuilder.create(blockEntityFactory::apply, (class_2248[])((class_2248[])((Set)validBlocks.get()).toArray(class_2248[]::new))).build());
    }

    @Override
    public <T extends class_1703, S> class_6880.class_6883<class_3917<T>> registerMenuType(String path, MenuSupplierWithData<T, S> menuSupplier, class_9139<? super class_9129, S> streamCodec) {
        return this.register(class_7924.field_41207, path, () -> new ExtendedScreenHandlerType(menuSupplier::create, streamCodec));
    }

    @Override
    public class_6880.class_6883<class_4158> registerPoiType(String path, int maxTickets, int validRange, Supplier<Set<class_2680>> matchingBlockStates) {
        return this.register(class_7924.field_41212, path, () -> PointOfInterestHelper.register((class_2960)this.makeKey(path), (int)maxTickets, (int)validRange, (Iterable)((Iterable)matchingBlockStates.get())), true);
    }

    @Override
    public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>> class_6880.class_6883<class_2314<?, ?>> registerArgumentType(String path, Class<? extends A> argumentClass, class_2314<A, T> argumentTypeInfo) {
        return this.register(class_7924.field_41262, path, () -> {
            ArgumentTypeRegistry.registerArgumentType((class_2960)this.makeKey(path), (Class)argumentClass, (class_2314)argumentTypeInfo);
            return argumentTypeInfo;
        }, true);
    }

    @Override
    public <T> class_6880.class_6883<class_2941<T>> registerEntityDataSerializer(String path, Supplier<class_2941<T>> entityDataSerializerSupplier) {
        class_5321<class_2941<?>> resourceKey = this.makeResourceKey(ENTITY_DATA_SERIALIZERS_REGISTRY_KEY, path);
        DirectReferenceHolder<class_2941<T>> holder = new DirectReferenceHolder<class_2941<T>>(resourceKey, entityDataSerializerSupplier.get());
        FabricTrackedDataRegistry.register((class_2960)holder.method_40237().method_29177(), (class_2941)((class_2941)holder.comp_349()));
        return holder;
    }

    @Override
    public <T> void prepareTag(class_5321<? extends class_2378<? super T>> registryKey, class_6862<T> tagKey) {
        this.isWritableOrThrow();
        Objects.requireNonNull(registryKey, "registry key is null");
        Objects.requireNonNull(tagKey, "tag key is null");
        class_2378 registry = LookupHelper.getRegistry(registryKey).orElseThrow();
        class_7923.method_62715(registry).method_46735(tagKey);
    }

    @Override
    public void freeze() {
        this.isWritableOrThrow();
        this.isFrozen = true;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }
}

