/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.renderer.v1.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_10096;
import net.minecraft.class_10097;
import net.minecraft.class_10526;
import net.minecraft.class_10819;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7775;
import net.minecraft.class_790;
import net.minecraft.class_7923;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import net.minecraft.class_9826;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class ModelLoadingHelper {
    private ModelLoadingHelper() {
    }

    @ApiStatus.Experimental
    public static class_9824.class_10095 loadBlockState(class_3300 resourceManager, class_2248 block) {
        return ModelLoadingHelper.loadBlockState(resourceManager, block, (Executor)class_156.method_18349()).join();
    }

    public static CompletableFuture<class_9824.class_10095> loadBlockState(class_3300 resourceManager, class_2248 block, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, class_7923.field_41175.method_10221((Object)block), (class_2689<class_2248, class_2680>)block.method_9595(), executor);
    }

    @ApiStatus.Experimental
    public static class_9824.class_10095 loadBlockState(class_3300 resourceManager, class_2960 identifier, class_2689<class_2248, class_2680> stateDefinition) {
        return ModelLoadingHelper.loadBlockState(resourceManager, identifier, stateDefinition, (Executor)class_156.method_18349()).join();
    }

    public static CompletableFuture<class_9824.class_10095> loadBlockState(class_3300 resourceManager, class_2960 identifier, class_2689<class_2248, class_2680> stateDefinition, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, identifier, identifier, stateDefinition, executor);
    }

    public static CompletableFuture<class_9824.class_10095> loadBlockState(class_3300 resourceManager, class_2960 oldIdentifier, class_2960 newIdentifier, class_2689<class_2248, class_2680> stateDefinition, Executor executor) {
        return ModelLoadingHelper.loadBlockState(resourceManager, oldIdentifier, executor).thenCompose(loadedBlockModelDefinitions -> ModelLoadingHelper.loadBlockState(loadedBlockModelDefinitions, newIdentifier, stateDefinition, executor));
    }

    public static CompletableFuture<List<class_9824.class_10094>> loadBlockState(class_3300 resourceManager, class_2960 identifier, Executor executor) {
        return CompletableFuture.supplyAsync(() -> resourceManager.method_14489(class_9824.field_55458.method_45112(identifier)), executor).thenApply(resourceStack -> {
            ArrayList<class_9824.class_10094> blockModelDefinitions = new ArrayList<class_9824.class_10094>(resourceStack.size());
            for (class_3298 resource : resourceStack) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        class_790 blockModelDefinition = (class_790)class_790.field_56928.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
                        blockModelDefinitions.add(new class_9824.class_10094(resource.method_14480(), blockModelDefinition));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Failed to load blockstate definition {} from pack {}", new Object[]{identifier, resource.method_14480(), exception});
                }
            }
            return blockModelDefinitions;
        });
    }

    public static CompletableFuture<class_9824.class_10095> loadBlockState(List<class_9824.class_10094> loadedBlockModelDefinitions, class_2960 identifier, class_2689<class_2248, class_2680> stateDefinition, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return class_9824.method_62627((class_2960)identifier, (class_2689)stateDefinition, (List)loadedBlockModelDefinitions);
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.error("Failed to load blockstate definition {}", (Object)identifier, (Object)exception);
                return null;
            }
        }, executor);
    }

    @ApiStatus.Experimental
    public static @Nullable class_1100 loadBlockModel(class_3300 resourceManager, class_2960 identifier) {
        return ModelLoadingHelper.loadBlockModel(resourceManager, identifier, (Executor)class_156.method_18349()).join();
    }

    public static CompletableFuture<@Nullable class_1100> loadBlockModel(class_3300 resourceManager, class_2960 identifier, Executor executor) {
        return CompletableFuture.supplyAsync(() -> resourceManager.method_14486(class_1092.field_53676.method_45112(identifier)), executor).thenApply(optional -> optional.map(resource -> {
            class_793 class_7932;
            block8: {
                BufferedReader reader = resource.method_43039();
                try {
                    class_7932 = class_793.method_3437((Reader)reader);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PuzzlesLib.LOGGER.error("Failed to load model {}", (Object)identifier, (Object)exception);
                        return null;
                    }
                }
                ((Reader)reader).close();
            }
            return class_7932;
        }).orElse(null));
    }

    public static class_1087.class_9979 missingModel() {
        return new class_1087.class_9979(){

            public class_1087 method_65542(class_2680 blockState, class_7775 modelBaker) {
                class_1100 unbakedModel = class_10096.method_62629();
                class_10819 resolvedModel = new class_10097(Collections.emptyMap(), unbakedModel).method_68022();
                return class_1088.class_10812.method_68021((class_10819)resolvedModel, (class_9826)modelBaker.method_65732(), (class_7775.class_12356)modelBaker.method_76674()).comp_3771();
            }

            public Object method_62332(class_2680 state) {
                return this;
            }

            public void method_62326(class_10526.class_10103 resolver) {
            }
        };
    }
}

