/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.platform.config.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.config.BalmConfig;
import net.blay09.mods.balm.platform.config.LoadedConfig;
import net.blay09.mods.balm.platform.config.MutableLoadedConfig;
import net.blay09.mods.balm.platform.config.reflection.internal.ConfigReflection;
import net.blay09.mods.balm.platform.config.reflection.internal.LoadedReflectionConfig;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.schema.ConfiguredProperty;
import net.blay09.mods.balm.platform.config.schema.builder.ConfigCategory;
import net.minecraft.class_2960;

public abstract class AbstractBalmConfig
implements BalmConfig {
    private final Map<class_2960, BalmConfigSchema> schemas = new ConcurrentHashMap<class_2960, BalmConfigSchema>();
    private final Map<class_2960, MutableLoadedConfig> localConfigs = new ConcurrentHashMap<class_2960, MutableLoadedConfig>();
    private final Map<class_2960, LoadedConfig> activeConfigs = new ConcurrentHashMap<class_2960, LoadedConfig>();
    private final Map<class_2960, Object> activeReflectionConfigs = new ConcurrentHashMap<class_2960, Object>();
    private final Multimap<class_2960, Consumer<MutableLoadedConfig>> configLoadHandlers = ArrayListMultimap.create();

    @Override
    public void registerConfig(BalmConfigSchema schema) {
        this.schemas.put(schema.identifier(), schema);
    }

    @Override
    public BalmConfigSchema getSchema(class_2960 identifier) {
        return this.schemas.get(identifier);
    }

    @Override
    public MutableLoadedConfig getLocalConfig(class_2960 identifier) {
        return this.localConfigs.get(identifier);
    }

    @Override
    public <T> void updateLocalConfig(Class<T> configDataClass, Consumer<T> updater) {
        BalmConfigSchema schema = this.getSchema(configDataClass);
        if (schema == null) {
            throw new IllegalArgumentException("No config schema found for " + configDataClass.getName());
        }
        MutableLoadedConfig localConfig = this.getLocalConfig(schema);
        if (localConfig == null) {
            throw new IllegalArgumentException("No local config loaded for " + String.valueOf(schema.identifier()));
        }
        LoadedReflectionConfig<T> reflectionConfig = ConfigReflection.of(configDataClass, localConfig);
        updater.accept(reflectionConfig.data());
        this.saveLocalConfig(schema, reflectionConfig);
    }

    @Override
    public LoadedConfig getActiveConfig(class_2960 identifier) {
        return this.activeConfigs.get(identifier);
    }

    @Override
    public Collection<BalmConfigSchema> getSchemasByNamespace(String namespace) {
        return this.schemas.values().stream().filter(schema -> schema.identifier().method_12836().equals(namespace)).toList();
    }

    @Override
    public Collection<BalmConfigSchema> getSchemas() {
        return this.schemas.values();
    }

    @Override
    public <T> T getActiveConfig(Class<T> configDataClass) {
        class_2960 identifier = ConfigReflection.getIdentifier(configDataClass);
        return (T)this.activeReflectionConfigs.computeIfAbsent(identifier, it -> BalmConfig.super.getActiveConfig(configDataClass));
    }

    @Override
    public void saveLocalConfig(BalmConfigSchema schema, MutableLoadedConfig config) {
        this.activeReflectionConfigs.remove(schema.identifier());
        this.localConfigs.put(schema.identifier(), config);
        this.updateActiveFromLocal(schema, config);
    }

    protected void updateActiveFromLocal(BalmConfigSchema schema, MutableLoadedConfig config) {
        MutableLoadedConfig newConfig = config.copy();
        if (Balm.safeClientAccess().isConnected() && !Balm.safeClientAccess().isLocalServer()) {
            LoadedConfig activeConfig = this.activeConfigs.get(schema.identifier());
            for (ConfiguredProperty<?> rootProperty : schema.rootProperties()) {
                if (!rootProperty.synced()) continue;
                newConfig.setRaw(rootProperty, activeConfig.getRaw(rootProperty));
            }
            for (ConfigCategory category : schema.categories()) {
                for (ConfiguredProperty<?> property : category.properties()) {
                    if (!property.synced()) continue;
                    newConfig.setRaw(property, activeConfig.getRaw(property));
                }
            }
        }
        this.setActiveConfig(schema, newConfig);
    }

    protected void setLocalConfig(BalmConfigSchema schema, MutableLoadedConfig config) {
        this.localConfigs.put(schema.identifier(), config);
    }

    public void setActiveConfig(BalmConfigSchema schema, LoadedConfig config) {
        this.activeReflectionConfigs.remove(schema.identifier());
        this.activeConfigs.put(schema.identifier(), config);
    }

    public void resetToLocalConfig() {
        this.activeReflectionConfigs.clear();
        this.activeConfigs.putAll(this.localConfigs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigAvailable(BalmConfigSchema schema, Consumer<MutableLoadedConfig> handler) {
        MutableLoadedConfig loaded = this.getLocalConfig(schema);
        if (loaded != null) {
            handler.accept(loaded);
        } else {
            Multimap<class_2960, Consumer<MutableLoadedConfig>> multimap = this.configLoadHandlers;
            synchronized (multimap) {
                this.configLoadHandlers.put((Object)schema.identifier(), handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConfigLoadHandlers(BalmConfigSchema schema, MutableLoadedConfig config) {
        Multimap<class_2960, Consumer<MutableLoadedConfig>> multimap = this.configLoadHandlers;
        synchronized (multimap) {
            this.configLoadHandlers.get((Object)schema.identifier()).forEach(handler -> handler.accept(config));
        }
    }
}

