/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.commands.internal;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.Collection;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.client.platform.util.IconExport;
import net.blay09.mods.balm.commands.BalmCommands;
import net.blay09.mods.balm.platform.config.schema.BalmConfigSchema;
import net.blay09.mods.balm.platform.config.util.ConfigJsonExport;
import net.minecraft.class_12099;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InternalsCommand {
    private static final Logger logger = LoggerFactory.getLogger(InternalsCommand.class);
    private static final class_2960 PERMISSION_BALM_DEV = class_2960.method_60655((String)"balm", (String)"command.balm.dev");
    private static final class_2960 PERMISSION_BALM_EXPORT_CONFIG = class_2960.method_60655((String)"balm", (String)"command.balm.export.config");
    private static final class_2960 PERMISSION_BALM_EXPORT_ICONS = class_2960.method_60655((String)"balm", (String)"command.balm.export.icons");
    private static int balmDevCounter;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        BalmCommands.registerPermission(PERMISSION_BALM_DEV, class_12099.field_63212);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_CONFIG, class_12099.field_63212);
        BalmCommands.registerPermission(PERMISSION_BALM_EXPORT_ICONS, class_12099.field_63212);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"balm").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dev").requires(BalmCommands.requirePermission(PERMISSION_BALM_DEV))).executes(context -> {
            if (Balm.platform().isDevelopmentEnvironment() || ++balmDevCounter >= 3) {
                class_2168 source = (class_2168)context.getSource();
                MinecraftServer server = source.method_9211();
                class_3218 level = source.method_9225();
                class_1928 gameRules = level.method_64395();
                gameRules.method_76186(class_1928.field_19396, (Object)false, server);
                source.method_9226(() -> class_2561.method_43470((String)"Daylight cycle disabled"), true);
                gameRules.method_76186(class_1928.field_19406, (Object)false, server);
                source.method_9226(() -> class_2561.method_43470((String)"Weather cycle disabled"), true);
                gameRules.method_76186(class_1928.field_19389, (Object)true, server);
                source.method_9226(() -> class_2561.method_43470((String)"Keep Inventory enabled"), true);
                gameRules.method_76186(class_1928.field_20637, (Object)false, server);
                source.method_9226(() -> class_2561.method_43470((String)"Insomnia disabled"), true);
                gameRules.method_76186(class_1928.field_19388, (Object)false, server);
                source.method_9226(() -> class_2561.method_43470((String)"Mob Griefing disabled"), true);
                gameRules.method_76186(class_1928.field_21832, (Object)false, server);
                source.method_9226(() -> class_2561.method_43470((String)"Trader Spawning disabled"), true);
                server.method_3776(class_1267.field_5801, true);
                source.method_9226(() -> class_2561.method_43470((String)"Difficulty set to Peaceful"), true);
                level.method_27910(99999, 0, false, false);
                source.method_9226(() -> class_2561.method_43470((String)"Weather cleared"), true);
                level.method_29199(1000L);
                source.method_9226(() -> class_2561.method_43470((String)"Set the time to Daytime"), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"This command will change several game rules and your world's difficulty. You should only use it if you know what you're doing!").method_27692(class_124.field_1061), true);
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"export").requires(BalmCommands.requireAnyPermission(PERMISSION_BALM_EXPORT_CONFIG, PERMISSION_BALM_EXPORT_ICONS))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_CONFIG))).then(class_2170.method_9244((String)"mod", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String mod = (String)context.getArgument("mod", String.class);
            Collection<BalmConfigSchema> schemas = Balm.config().getSchemasByNamespace(mod);
            try {
                ConfigJsonExport.exportToFile(schemas, new File("exports/config/" + mod + ".json"));
            }
            catch (Exception e) {
                logger.error("Error exporting config data class", (Throwable)e);
                throw new RuntimeException("Error exporting config data class: " + mod, e);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported config schema for " + mod)), false);
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"icons").requires(BalmCommands.requirePermission(PERMISSION_BALM_EXPORT_ICONS))).then(class_2170.method_9244((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String filter = (String)context.getArgument("filter", String.class);
            if (Balm.safeClientAccess().isClient()) {
                try {
                    IconExport.export(filter);
                }
                catch (Exception e) {
                    logger.error("Error exporting icons", (Throwable)e);
                    throw new RuntimeException("Error exporting icons for " + filter, e);
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Exported icons for " + filter)), false);
                return 1;
            }
            return 0;
        })))));
    }
}

