/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.KeyConverter;
import com.gitlab.cdagaming.unilib.utils.GameUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11908;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_458;
import org.lwjgl.glfw.GLFW;

public class KeyUtils {
    public static final KeyUtils INSTANCE = new KeyUtils();
    public final Map<String, Integer> keySyncQueue = StringUtils.newHashMap();
    private final Map<String, KeyBindData> registrationQueue = StringUtils.newConcurrentHashMap();
    private final Map<String, KeyBindData> KEY_MAPPINGS = StringUtils.newHashMap();
    private final Supplier<class_310> instance;
    private final int protocol;

    public KeyUtils(Supplier<class_310> instance, int protocol) {
        this.instance = instance;
        this.protocol = protocol;
    }

    public KeyUtils() {
        this(ModUtils.getMinecraftSupplier(), ModUtils.MCProtocolID);
    }

    public class_310 getInstance() {
        return this.instance.get();
    }

    public boolean isValidKeyCode(int sourceKeyCode) {
        return KeyConverter.isValidKeyCode(sourceKeyCode, this.protocol);
    }

    public boolean isValidClearCode(int sourceKeyCode) {
        return KeyConverter.isValidClearCode(sourceKeyCode, this.protocol);
    }

    public String getKeyName(int original) {
        return KeyConverter.getKeyName(original, this.protocol, (originalKeyCode, inputProtocol) -> GLFW.glfwGetKeyName((int)originalKeyCode, (int)GLFW.glfwGetKeyScancode((int)originalKeyCode)));
    }

    private class_304 createKey(String id, String name, class_304.class_11900 category, int defaultKey, int currentKey) {
        class_304 result = new class_304(name, defaultKey, category);
        this.keySyncQueue.put(id, currentKey);
        return result;
    }

    public class_304 registerKey(String id, String name, Function<String, String> nameFormatter, class_304.class_11900 category, Function<String, String> categoryFormatter, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        class_304 keyBind = this.createKey(id, name, category, defaultKey, currentKey);
        KeyBindData keyData = new KeyBindData(keyBind, nameFormatter, () -> ((class_304)keyBind).method_1423(), categoryFormatter, () -> keyBind.method_1429().method_1444(), detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
        this.KEY_MAPPINGS.put(id, keyData);
        this.registrationQueue.put(id, keyData);
        return keyBind;
    }

    public class_304 registerKey(String id, String name, class_304.class_11900 category, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, (String description) -> description, category, (String categoryName) -> categoryName, defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, class_304.class_11900 category, int defaultKey, int currentKey, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, category, defaultKey, currentKey, () -> "", canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, Function<String, String> nameFormatter, class_2960 category, Function<String, String> categoryFormatter, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, nameFormatter, class_304.class_11900.method_74698((class_2960)category), categoryFormatter, defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, Function<String, String> nameFormatter, String category, Function<String, String> categoryFormatter, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, nameFormatter, ResourceUtils.parseResource(category), categoryFormatter, defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, class_2960 category, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, class_304.class_11900.method_74698((class_2960)category), defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, ResourceUtils.parseResource(category), defaultKey, currentKey, detailsSupplier, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, class_2960 category, int defaultKey, int currentKey, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, class_304.class_11900.method_74698((class_2960)category), defaultKey, currentKey, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    public class_304 registerKey(String id, String name, String category, int defaultKey, int currentKey, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable onPress, BiConsumer<Integer, Boolean> onBind, Predicate<Integer> onOutdated, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> callback) {
        return this.registerKey(id, name, ResourceUtils.parseResource(category), defaultKey, currentKey, canCheckSupplier, canSyncSupplier, onPress, onBind, onOutdated, callback);
    }

    private void setKey(class_304 instance, int newKey) {
        boolean isLwjgl2 = this.protocol <= 340;
        int unknownKeyCode = isLwjgl2 ? -1 : 0;
        String unknownKeyName = (isLwjgl2 ? KeyConverter.fromGlfw : KeyConverter.toGlfw).get(unknownKeyCode).name();
        class_3675.class_306 inputKey = this.getKeyName(newKey).equals(unknownKeyName) ? class_3675.field_16237 : class_3675.method_15985((class_11908)new class_11908(newKey, GLFW.glfwGetKeyScancode((int)newKey), 0));
        instance.method_1422(inputKey);
        class_304.method_1426();
    }

    public boolean areKeysRegistered() {
        return this.registrationQueue.isEmpty();
    }

    public Set<Map.Entry<String, KeyBindData>> getRegistrationEntries() {
        return this.registrationQueue.entrySet();
    }

    public Set<String> getKeys() {
        return this.KEY_MAPPINGS.keySet();
    }

    public Set<Map.Entry<String, KeyBindData>> getKeyEntries() {
        return this.KEY_MAPPINGS.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTick() {
        if (this.instance == null || this.getInstance() == null) {
            return;
        }
        if (!this.areKeysRegistered()) {
            if (this.getInstance().field_1690 != null) {
                for (Map.Entry<String, KeyBindData> data : this.getRegistrationEntries()) {
                    this.getInstance().field_1690.field_1839 = StringUtils.addToArray(this.getInstance().field_1690.field_1839, data.getValue().binding());
                    this.registrationQueue.remove(data.getKey());
                }
            } else {
                return;
            }
        }
        if (this.getInstance().method_22683() != null) {
            boolean isLwjgl2 = this.protocol <= 340;
            int unknownKeyCode = isLwjgl2 ? -1 : 0;
            String unknownKeyName = (isLwjgl2 ? KeyConverter.fromGlfw : KeyConverter.toGlfw).get(unknownKeyCode).name();
            try {
                for (Map.Entry<String, KeyBindData> entry : this.getKeyEntries()) {
                    String keyName = entry.getKey();
                    KeyBindData keyData = entry.getValue();
                    if (!keyData.canCheck()) continue;
                    int currentBind = keyData.keyCode();
                    boolean hasBeenRun = false;
                    if (!(this.getKeyName(currentBind).equals(unknownKeyName) || this.isValidClearCode(currentBind) || GLFW.glfwGetKey((long)this.getInstance().method_22683().method_4490(), (int)currentBind) != 1 || GameUtils.getCurrentScreen(this.getInstance()) instanceof class_458)) {
                        try {
                            keyData.runEvent().run();
                        }
                        catch (Throwable ex) {
                            boolean resetKey;
                            if (keyData.errorCallback() != null) {
                                resetKey = keyData.errorCallback().apply(ex, new Pair<String, KeyBindData>(keyName, keyData));
                            } else {
                                CoreUtils.LOG.error(ex);
                                resetKey = true;
                            }
                            if (resetKey) {
                                this.syncKeyData(keyName, ImportMode.Specific, keyData.defaultKeyCode());
                            }
                        }
                        finally {
                            hasBeenRun = true;
                        }
                    }
                    if (hasBeenRun || !keyData.canSync()) continue;
                    if (this.keySyncQueue.containsKey(keyName)) {
                        this.syncKeyData(keyName, ImportMode.Config, this.keySyncQueue.get(keyName));
                        this.keySyncQueue.remove(keyName);
                        continue;
                    }
                    if (!keyData.vanillaPredicate().test(currentBind)) continue;
                    this.syncKeyData(keyName, ImportMode.Vanilla, currentBind);
                }
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
            }
        }
    }

    private void syncKeyData(String keyName, ImportMode mode, int keyCode) {
        KeyBindData keyData = this.KEY_MAPPINGS.getOrDefault(keyName, null);
        if (mode == ImportMode.Config) {
            this.setKey(keyData.binding(), keyCode);
        } else if (mode == ImportMode.Vanilla) {
            keyData.configEvent().accept(keyCode, true);
        } else if (mode == ImportMode.Specific) {
            this.syncKeyData(keyData.description(), ImportMode.Config, keyCode);
            this.syncKeyData(keyName, ImportMode.Vanilla, keyCode);
        }
    }

    public Map<String, KeyBindData> getKeyMappings(List<String> filterData) {
        Map<String, KeyBindData> filteredMappings = StringUtils.newHashMap();
        if (filterData == null || filterData.isEmpty()) {
            filteredMappings.putAll(this.KEY_MAPPINGS);
            return filteredMappings;
        }
        for (Map.Entry<String, KeyBindData> entry : this.getKeyEntries()) {
            String keyName = entry.getKey();
            KeyBindData keyData = entry.getValue();
            if (!filterData.contains(keyData.rawCategoryName())) continue;
            filteredMappings.put(keyName, keyData);
        }
        return filteredMappings;
    }

    public Map<String, KeyBindData> getKeyMappings(String ... filterData) {
        return this.getKeyMappings(filterData == null || filterData.length == 0 ? null : StringUtils.newArrayList(filterData));
    }

    public record KeyBindData(class_304 binding, Function<String, String> nameFormatter, Supplier<class_304.class_11900> categorySupplier, Function<String, String> categoryFormatter, Supplier<Integer> defaultKeySupplier, Supplier<String> detailsSupplier, Supplier<Boolean> canCheckSupplier, Supplier<Boolean> canSyncSupplier, Runnable runEvent, BiConsumer<Integer, Boolean> configEvent, Predicate<Integer> vanillaPredicate, BiFunction<Throwable, Pair<String, KeyBindData>, Boolean> errorCallback) {
        public class_304.class_11900 category() {
            return this.categorySupplier().get();
        }

        public String rawCategoryName() {
            return this.category().comp_4879().method_42093("key.category");
        }

        public String categoryName() {
            return this.categoryFormatter().apply(this.rawCategoryName());
        }

        public String details() {
            return this.detailsSupplier().get();
        }

        public boolean canCheck() {
            return this.canCheckSupplier.get();
        }

        public boolean canSync() {
            return this.canSyncSupplier.get();
        }

        public String description() {
            return this.binding().method_1431();
        }

        public String displayName() {
            return this.nameFormatter().apply(this.description());
        }

        public int keyCode() {
            return this.binding().field_1655.method_1444();
        }

        public int defaultKeyCode() {
            return this.defaultKeySupplier().get();
        }
    }

    public static enum ImportMode {
        Config,
        Vanilla,
        Specific;

    }
}

