/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config.gui;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.clothconfig2.gui.entries.StringListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.minecraft.class_2561;
import net.xolt.freecam.config.gui.AutoConfigExtensions;
import net.xolt.freecam.config.gui.ValidateRegex;
import org.apache.commons.lang3.StringUtils;

class ValidateRegexImpl {
    private ValidateRegexImpl() {
    }

    static void apply(GuiRegistry registry) {
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            guis.stream().filter(StringListEntry.class::isInstance).map(StringListEntry.class::cast).forEach(entry -> entry.setErrorSupplier(() -> ValidateRegexImpl.regexCompileError(entry.getValue())));
            return guis;
        }, field -> Objects.equals(String.class, field.getType()), new Class[]{ValidateRegex.class});
        registry.registerAnnotationTransformer((guis, i18n, field, config, defaults, guiProvider) -> {
            guis.stream().filter(StringListListEntry.class::isInstance).map(StringListListEntry.class::cast).forEach(entry -> entry.setCellErrorSupplier(ValidateRegexImpl::regexCompileError));
            return guis;
        }, AutoConfigExtensions.isArrayOrListOfType(new Type[]{String.class}), new Class[]{ValidateRegex.class});
    }

    private static Optional<class_2561> regexCompileError(String text) {
        try {
            Pattern.compile(text);
            return Optional.empty();
        }
        catch (PatternSyntaxException e) {
            String message = StringUtils.substringBefore((String)e.getLocalizedMessage(), (int)10);
            return Optional.of(class_2561.method_43469((String)"text.autoconfig.freecam.error.invalidRegex", (Object[])new Object[]{message}));
        }
    }
}

