/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_10419;
import net.minecraft.class_1058;
import net.minecraft.class_10802;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_796;
import net.minecraft.class_801;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;

public class ConnectingModelDataImpl
extends BaseModelDataImpl
implements ConnectingModelData {
    private final Map<String, ConnectionPredicate> predicates;
    private final Map<String, String> connectionReferences;

    public ConnectingModelDataImpl(class_793 model, List<class_2960> parents, List<ConnectingModelElement> elements, Map<String, ConnectionPredicate> predicates, Map<String, String> references) {
        super(model, parents, elements);
        this.predicates = ImmutableMap.copyOf(predicates);
        this.connectionReferences = ImmutableMap.copyOf(references);
    }

    public List<ConnectingModelElement> getElements() {
        return super.getElements();
    }

    @Override
    public ConnectionPredicate getConnectionPredicate(String texture) {
        return this.predicates.get(texture);
    }

    @Override
    public ConnectionPredicate getDefaultConnectionPredicate() {
        return this.getConnectionPredicate("default");
    }

    @Override
    public Map<String, ConnectionPredicate> getAllConnectionPredicates() {
        return this.predicates;
    }

    public Map<String, String> getConnectionReferences() {
        return this.connectionReferences;
    }

    @Override
    public List<BaseModelQuad> bakeQuads(BlockModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.CONNECTING, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(BlockModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).getElements();
        } else {
            Object object;
            class_1100 vanillaModel = model.getAsVanillaModel();
            if (vanillaModel instanceof class_801) {
                elements = this.generateItemModel(context, modelStack);
            } else if (vanillaModel != null && (object = vanillaModel.comp_3739()) instanceof class_10802) {
                class_10802 geometry = (class_10802)object;
                elements = geometry.comp_3753();
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (class_785 element : elements) {
                for (class_2350 direction : element.comp_3729().keySet()) {
                    class_783 face = (class_783)element.comp_3729().get(direction);
                    class_1058 sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.comp_2869()));
                    class_777 quad = class_796.method_3468((class_7775.class_12356)context.getModelBaker().method_76674(), (Vector3fc)element.comp_3727(), (Vector3fc)element.comp_3728(), (class_783)face, (class_1058)sprite, (class_2350)direction, (class_3665)context.getTransformation(), (class_789)element.comp_3730(), (boolean)element.comp_3731(), (int)element.comp_3732());
                    class_2350 cullDirection = face.comp_2867() != null ? class_2350.method_23225((Matrix4fc)context.getTransformation().method_3509().method_22936(), (class_2350)face.comp_2867()) : null;
                    String connectionsKey = element instanceof ConnectingModelElement && ((ConnectingModelElement)element).faceConnectionKeys.containsKey(direction) ? ((ConnectingModelElement)element).faceConnectionKeys.get(direction) : face.comp_2869();
                    ConnectionPredicate predicate = this.resolveConnectionKey(context, modelStack, connectionsKey);
                    output.accept(new ConnectingModelQuad(quad, cullDirection, predicate));
                }
            }
            modelStack.pop();
            return;
        }
        for (class_2960 location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    private ConnectionPredicate resolveConnectionKey(BlockModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            String newKey = null;
            for (ModelInstance<?> model : modelStack) {
                if (model.getModelType() != DefaultModelTypes.CONNECTING) continue;
                ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(currentKey);
                if (predicate != null) {
                    return predicate;
                }
                String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(currentKey);
                if (reference == null) continue;
                newKey = reference;
                break;
            }
            if (newKey == null) {
                for (ModelInstance<?> model : modelStack) {
                    class_10419.class_10424 material;
                    class_1100 vanillaModel = model.getAsVanillaModel();
                    if (vanillaModel == null || (material = (class_10419.class_10424)vanillaModel.comp_3743().comp_3376().get(currentKey)) == null) continue;
                    newKey = material instanceof class_10419.class_10425 ? ((class_10419.class_10425)material).comp_3378().method_24147().toString() : ((class_10419.class_10422)material).comp_3377();
                    break;
                }
            }
            if (newKey == null) {
                Either<ConnectionPredicate, String> entry = ConnectingModelDataImpl.findConnectionsEntry(context, modelStack.getLast(), currentKey);
                if (entry != null && entry.isLeft()) {
                    return entry.left();
                }
                if (entry != null && entry.isRight()) {
                    newKey = entry.right();
                }
            }
            if (newKey == null && !currentKey.equals("default")) {
                newKey = "default";
            }
            if (newKey == null) {
                return null;
            }
            currentKey = newKey;
            if (currentKey.charAt(0) == '#') {
                currentKey = currentKey.substring(1);
            }
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve connections due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return null;
            }
            encounteredKeys.add(currentKey);
        }
    }

    private static Either<ConnectionPredicate, String> findConnectionsEntry(BlockModelBakingContext context, ModelInstance<?> model, String key) {
        if (model.getModelType() == DefaultModelTypes.CONNECTING) {
            ConnectionPredicate predicate = ((ConnectingModelDataImpl)model.getModelData()).predicates.get(key);
            if (predicate != null) {
                return Either.left(predicate);
            }
            String reference = ((ConnectingModelDataImpl)model.getModelData()).connectionReferences.get(key);
            if (reference != null) {
                return Either.right(reference);
            }
        }
        for (class_2960 location : model.getParentModels()) {
            Either<ConnectionPredicate, String> entry;
            ModelInstance<?> parent = context.getModel(location);
            if (parent == null || (entry = ConnectingModelDataImpl.findConnectionsEntry(context, parent, key)) == null) continue;
            return entry;
        }
        return null;
    }
}

