/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.entity.model.predicates.AltitudeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.AndEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BabyEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BiomeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.DimensionEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import com.supermartijn642.fusion.entity.model.predicates.NotEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.OrEntityModelPredicate;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.PredicateRegistryImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11515;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");
    public static final ThreadLocal<Boolean> IS_RENDERING_BREAKING_OVERLAY = new ThreadLocal();
    private static String fusionVersion;

    public void onInitializeClient() {
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"base"), DefaultTextureTypes.BASE);
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"scrolling"), DefaultTextureTypes.SCROLLING);
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"random"), DefaultTextureTypes.RANDOM);
        FusionTextureTypeRegistry.registerTextureType(class_2960.method_60655((String)"fusion", (String)"continuous"), DefaultTextureTypes.CONTINUOUS);
        FusionModelTypeRegistry.registerModelType(class_2960.method_60655((String)"fusion", (String)"unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(class_2960.method_60655((String)"fusion", (String)"vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(class_2960.method_60655((String)"fusion", (String)"base"), DefaultModelTypes.BASE);
        FusionModelTypeRegistry.registerModelType(class_2960.method_60655((String)"fusion", (String)"connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"is_direction"), IsDirectionConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"match_block_in_front"), MatchBlockInFrontConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"match_state"), MatchStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(class_2960.method_60655((String)"fusion", (String)"match_state_in_front"), MatchStateInFrontConnectionPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"and"), AndItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"or"), OrItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"not"), NotItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"count"), CountItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"durability"), DurabilityItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"enchantment"), EnchantmentItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(class_2960.method_60655((String)"fusion", (String)"potion"), PotionItemPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"and"), AndEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"or"), OrEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"not"), NotEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"altitude"), AltitudeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"is_baby"), BabyEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"biome"), BiomeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(class_2960.method_60655((String)"fusion", (String)"dimension"), DimensionEntityModelPredicate.SERIALIZER);
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> TextureTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> ModelTypeRegistryImpl.finalizeRegistration());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> PredicateRegistryImpl.finalizeRegistration());
    }

    public static void applyMaterialProperties(QuadEmitter emitter, Boolean ambientOcclusion, BaseTextureData.RenderType renderType, boolean emissive) {
        emitter.shadeMode(ShadeMode.VANILLA);
        emitter.ambientOcclusion(ambientOcclusion == null ? TriState.DEFAULT : (ambientOcclusion != false ? TriState.TRUE : TriState.FALSE));
        class_11515 layer = renderType == BaseTextureData.RenderType.OPAQUE ? class_11515.field_60923 : (renderType == BaseTextureData.RenderType.CUTOUT ? class_11515.field_60925 : (renderType == BaseTextureData.RenderType.TRANSLUCENT ? class_11515.field_60926 : null));
        emitter.renderLayer(layer);
        if (emissive) {
            emitter.emissive(true).diffuseShade(true).ambientOcclusion(TriState.FALSE);
        }
    }

    public static String getFusionVersion() {
        if (fusionVersion == null) {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer("fusion").orElseThrow()).getMetadata().getVersion().getFriendlyString();
            if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
                version = version.substring(0, version.length() - version.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
            }
            fusionVersion = version;
        }
        return fusionVersion;
    }
}

