/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.crend.dynamiccrosshair.compat.YaclIntegration;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.ConfigHandler;
import mod.crend.dynamiccrosshair.impl.VanillaApiImpl;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.libbamboo.LibBamboo;
import mod.crend.libbamboo.PlatformUtils;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public class DynamicCrosshairMod
implements ClientModInitializer {
    public static ConfigHandler config;
    public static final Map<String, DynamicCrosshairApi> apis;
    public static final Set<String> alwaysCheckedApis;
    public static final DynamicCrosshairApi vanillaApi;

    public static void registerApi(DynamicCrosshairApi apiImpl) {
        if (PlatformUtils.isModLoaded((String)apiImpl.getModId())) {
            apiImpl.init();
            String identifier = apiImpl.getNamespace();
            apis.put(identifier, apiImpl);
            if (apiImpl.forceCheck()) {
                alwaysCheckedApis.add(identifier);
            }
        }
    }

    public static void init() {
        config = new ConfigHandler();
        if (LibBamboo.HAS_YACL) {
            YaclIntegration.listen();
        }
    }

    public void onInitializeClient() {
        DynamicCrosshairMod.init();
        ClientTickEvents.END_CLIENT_TICK.register(event -> CrosshairHandler.tick());
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            ConfigHandler.CONFIG_STORE.reload();
            CrosshairStyleManager.INSTANCE.init();
        });
        FabricLoader.getInstance().getEntrypointContainers("dynamiccrosshair", DynamicCrosshairApi.class).stream().map(EntrypointContainer::getEntrypoint).filter(api -> FabricLoader.getInstance().isModLoaded(api.getModId())).forEach(DynamicCrosshairMod::registerApi);
    }

    static {
        apis = new HashMap<String, DynamicCrosshairApi>();
        alwaysCheckedApis = new HashSet<String>();
        vanillaApi = new VanillaApiImpl();
    }
}

