/*
 * Decompiled with CFR 0.152.
 */
package b100.gui.config;

import b100.fullscreenfix.FullscreenFix;
import b100.gui.ActionListener;
import b100.gui.GuiButton;
import b100.gui.GuiContainer;
import b100.gui.GuiElement;
import b100.gui.GuiScreen;
import b100.gui.ScreenListener;
import b100.gui.config.ConfigElement;
import b100.gui.config.ConfigElementListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class BooleanToggleElement
extends GuiContainer
implements ActionListener,
ConfigElement<Boolean>,
ScreenListener {
    protected GuiScreen screen;
    protected class_2561 name;
    protected boolean initialValue;
    protected boolean value;
    protected boolean defaultValue;
    protected GuiButton button;
    protected class_2561 tooltipText;
    private final List<ConfigElementListener> configElementListeners = new ArrayList<ConfigElementListener>();
    private final List<Consumer<Boolean>> saveConsumers = new ArrayList<Consumer<Boolean>>();

    public BooleanToggleElement(GuiScreen screen, String key, boolean value) {
        this.screen = screen;
        this.name = FullscreenFix.translate(key);
        this.initialValue = this.defaultValue = value;
        this.value = this.defaultValue;
        String tooltipText = FullscreenFix.translateIfExists(key + ".tooltip");
        if (tooltipText != null) {
            this.tooltipText = class_2561.method_30163((String)tooltipText);
        }
        this.button = this.add(new GuiButton(screen, null).addActionListener(this));
        this.button.setSize(112, 20);
        this.setSize(320, 24);
        this.update();
    }

    @Override
    public void draw() {
        GuiElement mouseOver = this.button.screen.getMouseOver();
        if (mouseOver == this || this.contains(mouseOver) || this.button.isFocused()) {
            this.utils.drawRectangle(this.posX, this.posY, this.width, this.height, 0x20FFFFFF);
            if (this.tooltipText != null) {
                this.screen.drawWrappedTooltip(this.tooltipText);
            }
        }
        super.draw();
        this.utils.drawString(this.name, this.posX + 8, this.posY + this.height / 2 - 4, 0xFFFFFF, true);
    }

    @Override
    public void actionPerformed(GuiElement source) {
        this.value = !this.value;
        for (ConfigElementListener configElementListener : this.configElementListeners) {
            configElementListener.valueChanged(this);
        }
        this.update();
    }

    @Override
    public void onResize() {
        this.button.setPosition(this.posX + this.width - this.button.width - 2, this.posY + this.height / 2 - this.button.height / 2);
        super.onResize();
    }

    public void update() {
        this.button.text = class_2561.method_30163((String)(this.value ? "\u00a7a" + FullscreenFix.translateToString("value.yes") : "\u00a7c" + FullscreenFix.translateToString("value.no")));
    }

    public boolean getValue() {
        return this.value;
    }

    public BooleanToggleElement setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    public BooleanToggleElement setTooltipText(class_2561 tooltipText) {
        this.tooltipText = tooltipText;
        return this;
    }

    public class_2561 getTooltipText() {
        return this.tooltipText;
    }

    @Override
    public boolean isChanged() {
        return this.value != this.initialValue;
    }

    @Override
    public GuiElement addConfigElementListener(ConfigElementListener listener) {
        this.configElementListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeConfigElementListener(ConfigElementListener listener) {
        return this.configElementListeners.remove(listener);
    }

    @Override
    public void resetToInitialValue() {
        this.value = this.initialValue;
    }

    @Override
    public void resetToDefaultValue() {
        this.value = this.defaultValue;
    }

    @Override
    public boolean isDefaultValue() {
        return this.value == this.defaultValue;
    }

    @Override
    public void save() {
        if (this.initialValue != this.value) {
            this.initialValue = this.value;
        }
        for (Consumer<Boolean> saveConsumer : this.saveConsumers) {
            saveConsumer.accept(this.value);
        }
    }

    @Override
    public GuiElement addSaveConsumer(Consumer<Boolean> saveListener) {
        this.saveConsumers.add(saveListener);
        return this;
    }

    @Override
    public boolean removeSaveConsumer(Consumer<Boolean> saveListener) {
        return this.saveConsumers.remove(saveListener);
    }

    @Override
    public void onScreenOpened(GuiScreen screen) {
        this.update();
    }

    @Override
    public boolean isSolid() {
        return true;
    }
}

