/*
 * Decompiled with CFR 0.152.
 */
package cn.enaium.noexpensive;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u001c\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcn/enaium/noexpensive/Config;", "", "<init>", "()V", "", "load", "save", "reset", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configFile", "Ljava/nio/file/Path;", "Lcn/enaium/noexpensive/Config$Model;", "value", "model", "Lcn/enaium/noexpensive/Config$Model;", "getModel", "()Lcn/enaium/noexpensive/Config$Model;", "Model", "NE"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    private static final Path configFile;
    @NotNull
    private static Model model;

    private Config() {
    }

    @NotNull
    public final Model getModel() {
        return model;
    }

    public final void load() {
        Path path = configFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                Gson gson = new Gson();
                Path path3 = configFile;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"configFile");
                Object object = gson.fromJson(PathsKt.readText((Path)path3, (Charset)Charsets.UTF_8), Model.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                model = (Model)object;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.save();
        }
    }

    public final void save() {
        try {
            Path path = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFile");
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Path path2 = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configFile");
            String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)model);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            PathsKt.writeText((Path)path2, (CharSequence)string, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void reset() {
        model = new Model();
        this.save();
    }

    static {
        String string = System.getProperty("user.dir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        configFile = path.resolve("config").resolve("NoExpensive.json");
        model = new Model();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R4\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00140\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcn/enaium/noexpensive/Config$Model;", "", "<init>", "()V", "", "maxLevel", "I", "getMaxLevel", "()I", "setMaxLevel", "(I)V", "", "combineHigher", "Z", "getCombineHigher", "()Z", "setCombineHigher", "(Z)V", "", "", "", "compatibility", "Ljava/util/Map;", "getCompatibility", "()Ljava/util/Map;", "setCompatibility", "(Ljava/util/Map;)V", "NE"})
    public static final class Model {
        private int maxLevel = 39;
        private boolean combineHigher;
        @NotNull
        private Map<String, List<String>> compatibility;

        public Model() {
            Pair[] pairArray = new Pair[11];
            Object[] objectArray = new String[]{"minecraft:infinity"};
            pairArray[0] = TuplesKt.to((Object)"minecraft:mending", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:piercing"};
            pairArray[1] = TuplesKt.to((Object)"minecraft:multishot", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:smite", "minecraft:bane_of_arthropods"};
            pairArray[2] = TuplesKt.to((Object)"minecraft:sharpness", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:bane_of_arthropods", "minecraft:sharpness"};
            pairArray[3] = TuplesKt.to((Object)"minecraft:smite", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:sharpness", "minecraft:smite"};
            pairArray[4] = TuplesKt.to((Object)"minecraft:bane_of_arthropods", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:breach", "minecraft:sharpness", "minecraft:smite", "minecraft:bane_of_arthropods"};
            pairArray[5] = TuplesKt.to((Object)"minecraft:density", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:density", "minecraft:sharpness", "minecraft:smite", "minecraft:bane_of_arthropods"};
            pairArray[6] = TuplesKt.to((Object)"minecraft:breach", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:projectile_protection", "minecraft:blast_protection", "minecraft:fire_protection"};
            pairArray[7] = TuplesKt.to((Object)"minecraft:protection", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:blast_protection", "minecraft:fire_protection", "minecraft:protection"};
            pairArray[8] = TuplesKt.to((Object)"minecraft:projectile_protection", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:fire_protection", "minecraft:protection", "minecraft:projectile_protection"};
            pairArray[9] = TuplesKt.to((Object)"minecraft:blast_protection", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            objectArray = new String[]{"minecraft:protection", "minecraft:projectile_protection", "minecraft:blast_protection"};
            pairArray[10] = TuplesKt.to((Object)"minecraft:fire_protection", (Object)CollectionsKt.mutableListOf((Object[])objectArray));
            this.compatibility = MapsKt.mutableMapOf((Pair[])pairArray);
        }

        public final int getMaxLevel() {
            return this.maxLevel;
        }

        public final void setMaxLevel(int n) {
            this.maxLevel = n;
        }

        public final boolean getCombineHigher() {
            return this.combineHigher;
        }

        public final void setCombineHigher(boolean bl) {
            this.combineHigher = bl;
        }

        @NotNull
        public final Map<String, List<String>> getCompatibility() {
            return this.compatibility;
        }

        public final void setCompatibility(@NotNull Map<String, List<String>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.compatibility = map;
        }
    }
}

