/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.integration;

import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.provider.ItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.impl.ContainerProvider;
import java.util.function.BiConsumer;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;

public final class ReinforcedShulkerBoxesIntegration {
    private ReinforcedShulkerBoxesIntegration() {
    }

    public static void registerModProviders(BiConsumer<class_2960, ItemContentsProvider> providerRegistrar) {
        for (ShulkerBoxMaterial material : ShulkerBoxMaterial.values()) {
            providerRegistrar.accept(material.id(), (ItemContentsProvider)new ContainerProvider(material.width, material.height, null).filterContainerItems(true));
            for (class_1767 dyeColor : class_1767.values()) {
                providerRegistrar.accept(material.id(dyeColor), (ItemContentsProvider)new ContainerProvider(material.width, material.height, DyeBackedColor.fromDyeColor((class_1767)dyeColor)).filterContainerItems(true));
            }
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"reinfshulker", (String)path);
    }

    private static enum ShulkerBoxMaterial {
        COPPER("copper", 9, 5),
        IRON("iron", 9, 6),
        GOLD("gold", 9, 9),
        DIAMOND("diamond", 12, 9),
        NETHERITE("netherite", 12, 9);

        public final String name;
        public final int width;
        public final int height;

        private ShulkerBoxMaterial(String name, int width, int height) {
            this.name = name;
            this.width = width;
            this.height = height;
        }

        public class_2960 id() {
            return this.id(null);
        }

        public class_2960 id(@Nullable class_1767 dyeColor) {
            Object path = this.name + "_shulker_box";
            if (dyeColor != null) {
                path = "%s_%s".formatted(dyeColor.method_15434(), path);
            }
            return ReinforcedShulkerBoxesIntegration.id((String)path);
        }
    }
}

