/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractTextFieldListListEntry;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerListListEntry
extends AbstractTextFieldListListEntry<Integer, IntegerListCell, IntegerListListEntry> {
    private int minimum = Integer.MIN_VALUE;
    private int maximum = Integer.MAX_VALUE;

    @Deprecated
    @ApiStatus.Internal
    public IntegerListListEntry(class_2561 fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, class_2561 resetButtonKey) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListListEntry(class_2561 fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart) {
        this(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, true, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public IntegerListListEntry(class_2561 fieldName, List<Integer> value, boolean defaultExpanded, Supplier<Optional<class_2561[]>> tooltipSupplier, Consumer<List<Integer>> saveConsumer, Supplier<List<Integer>> defaultValue, class_2561 resetButtonKey, boolean requiresRestart, boolean deleteButtonEnabled, boolean insertInFront) {
        super(fieldName, value, defaultExpanded, tooltipSupplier, saveConsumer, defaultValue, resetButtonKey, requiresRestart, deleteButtonEnabled, insertInFront, IntegerListCell::new);
    }

    public IntegerListListEntry setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public IntegerListListEntry setMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    @Override
    public IntegerListListEntry self() {
        return this;
    }

    public static class IntegerListCell
    extends AbstractTextFieldListListEntry.AbstractTextFieldListCell<Integer, IntegerListCell, IntegerListListEntry> {
        public IntegerListCell(Integer value, IntegerListListEntry listListEntry) {
            super(value, listListEntry);
        }

        @Override
        @Nullable
        protected Integer substituteDefault(@Nullable Integer value) {
            if (value == null) {
                return 0;
            }
            return value;
        }

        @Override
        protected boolean isValidText(@NotNull String text) {
            return text.chars().allMatch(c -> Character.isDigit(c) || c == 45);
        }

        @Override
        public Integer getValue() {
            try {
                return Integer.valueOf(this.widget.method_1882());
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        @Override
        public Optional<class_2561> getError() {
            try {
                int i = Integer.parseInt(this.widget.method_1882());
                if (i > ((IntegerListListEntry)this.listListEntry).maximum) {
                    return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_large", (Object[])new Object[]{((IntegerListListEntry)this.listListEntry).maximum}));
                }
                if (i < ((IntegerListListEntry)this.listListEntry).minimum) {
                    return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_small", (Object[])new Object[]{((IntegerListListEntry)this.listListEntry).minimum}));
                }
            }
            catch (NumberFormatException ex) {
                return Optional.of(class_2561.method_43471((String)"text.cloth-config.error.not_valid_number_int"));
            }
            return Optional.empty();
        }
    }
}

