/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.util;

import com.google.common.collect.ImmutableSortedMap;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9848;

public class DisplayEntryRenderHelper {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60656((String)"tooltip/background");
    private static final class_2960 FRAME_SPRITE = class_2960.method_60656((String)"tooltip/frame");
    private static final NavigableMap<Integer, Character> MAP = ImmutableSortedMap.naturalOrder().put((Object)1000, (Object)Character.valueOf('K')).put((Object)1000000, (Object)Character.valueOf('M')).put((Object)1000000000, (Object)Character.valueOf('B')).build();
    private static float itemStackAlpha = 1.0f;

    public static void renderItem(class_332 guiGraphics, class_1799 itemStack, int x, int y, float alpha) {
        itemStackAlpha = alpha;
        guiGraphics.method_51427(itemStack, x, y);
        itemStackAlpha = 1.0f;
    }

    public static float getItemStackAlpha() {
        return itemStackAlpha;
    }

    private static class_5250 shortenValue(int value) {
        Map.Entry<Integer, Character> entry = MAP.floorEntry(value);
        if (entry == null) {
            return class_2561.method_43470((String)String.valueOf(value));
        }
        return class_2561.method_43470((String)(String.valueOf(value / entry.getKey()) + String.valueOf(entry.getValue())));
    }

    public static void renderGuiItemDecorations(class_332 guiGraphics, class_327 font, int count, int xPosition, int yPosition, float alpha) {
        if (count <= 1 && !((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            return;
        }
        guiGraphics.method_51448().pushMatrix();
        class_5250 component = DisplayEntryRenderHelper.shortenValue(count);
        float scale = Math.min(1.0f, 16.0f / (float)font.method_27525((class_5348)component));
        guiGraphics.method_51448().scale(scale, scale);
        float posX = (float)(xPosition + 17) / scale - (float)font.method_27525((class_5348)component);
        Objects.requireNonNull(font);
        float f = (float)(yPosition + 9 * 2) / scale;
        Objects.requireNonNull(font);
        float posY = f - 9.0f;
        guiGraphics.method_51439(font, (class_2561)component, (int)posX, (int)posY, class_9848.method_71346((float)alpha, (int)-1), true);
        guiGraphics.method_51448().popMatrix();
    }

    public static void renderTooltipBackground(class_332 guiGraphics, int x, int y, int width, int height, int color) {
        int i = x - 3 - 9;
        int j = y - 3 - 9;
        int k = width + 3 + 3 + 18;
        int l = height + 3 + 3 + 18;
        guiGraphics.method_52707(class_10799.field_56883, BACKGROUND_SPRITE, i, j, k, l, color);
        guiGraphics.method_52707(class_10799.field_56883, FRAME_SPRITE, i, j, k, l, color);
    }
}

