/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.ui;

import eu.pb4.graves.GraveTextures;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.ui.GuiSlot;
import eu.pb4.graves.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class AllGraveListGui
extends PagedGui {
    private final boolean canModify;
    private int ticker = 0;
    private List<Grave> graves;
    private boolean canFetch;

    public AllGraveListGui(class_3222 player, boolean canModify, boolean canFetch) {
        super(player);
        this.setTitle(ConfigManager.getConfig().ui.adminGraveListTitle.text());
        this.graves = new ArrayList<Grave>(GraveManager.INSTANCE.getAll());
        this.canModify = canModify;
        this.canFetch = canFetch;
        this.updateDisplay();
    }

    @Override
    protected int getPageAmount() {
        return this.graves.size() / 36 + 1;
    }

    @Override
    protected GuiSlot getElement(int id) {
        if (id < this.graves.size()) {
            Config config = ConfigManager.getConfig();
            Grave grave = this.graves.get(id);
            Map<String, class_2561> placeholders = grave.getPlaceholders(this.player.method_51469().method_8503());
            GuiElementBuilder element = config.ui.listAllGraveIcon.get(grave.isProtected()).builder(placeholders).setCallback((index, type, action) -> grave.openUi(this.player, this.canModify, this.canFetch));
            return GuiSlot.of(element);
        }
        return GuiSlot.empty();
    }

    @Override
    protected GuiSlot getNavElement(int id) {
        return switch (id) {
            case 2 -> GuiSlot.previousPage(this);
            case 6 -> GuiSlot.nextPage(this);
            default -> GraveTextures.hasGuiTexture(this.player) ? GuiSlot.empty() : GuiSlot.filler();
        };
    }

    public void onTick() {
        ++this.ticker;
        if (this.ticker % 20 == 0) {
            this.graves = new ArrayList<Grave>(GraveManager.INSTANCE.getAll());
            this.updateDisplay();
        }
        super.onTick();
    }
}

