/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo;

import io.github.a5b84.helditeminfo.HeldItemInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_10712;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;

public class TooltipBuilder {
    public static final class_124 DEFAULT_COLOR = class_124.field_1080;
    private final class_1792.class_9635 tooltipContext;
    private final class_1799 stack;
    private final class_10712 displayComponent;
    private final int maxSize;
    private final List<class_2561> lines;
    private int realSize;

    public TooltipBuilder(class_1799 stack) {
        this.tooltipContext = class_1792.class_9635.method_59528((class_1937)class_310.method_1551().field_1687);
        this.maxSize = HeldItemInfo.config.maxLines();
        this.realSize = 0;
        this.stack = stack;
        this.displayComponent = HeldItemInfo.config.respectHideFlags() ? (class_10712)stack.method_58695(class_9334.field_56400, (Object)class_10712.field_56318) : class_10712.field_56318;
        this.lines = new ArrayList<class_2561>(this.maxSize);
    }

    public class_1792.class_9635 getTooltipContext() {
        return this.tooltipContext;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public class_10712 getDisplayComponent() {
        return this.displayComponent;
    }

    public boolean shouldDisplayComponents() {
        return !this.displayComponent.comp_3600();
    }

    public <T> Optional<T> getComponentForDisplay(class_9331<T> componentType) {
        Object component = this.getStack().method_58694(componentType);
        if (component != null && this.displayComponent.method_67214(componentType)) {
            return Optional.of(component);
        }
        return Optional.empty();
    }

    public Optional<class_2487> getBlockEntityData() {
        return this.getComponentForDisplay(class_9334.field_49611).map(class_11580::method_72540);
    }

    public <T extends class_9299> void appendComponent(class_9331<T> componentType) {
        this.appendComponent(componentType, this::append);
    }

    public <T extends class_9299> void appendComponent(class_9331<T> componentType, UnaryOperator<class_2561> transformation) {
        this.appendComponent(componentType, (class_2561 text) -> this.append(this.canAdd() ? (class_2561)transformation.apply((class_2561)text) : text));
    }

    public <T extends class_9299> void appendComponent(class_9331<T> componentType, Consumer<class_2561> textConsumer) {
        this.getComponentForDisplay(componentType).ifPresent(component -> component.method_57409(this.getTooltipContext(), textConsumer, (class_1836)class_1836.field_41070, (class_9473)this.getStack().method_57353()));
    }

    public boolean canAdd() {
        return this.lines.size() < this.maxSize;
    }

    public int getRemainingLines() {
        return this.maxSize - this.lines.size();
    }

    public void append(class_2561 text) {
        ++this.realSize;
        if (this.canAdd()) {
            this.lines.add(text);
        }
    }

    public void append(Supplier<class_2561> textSupplier) {
        ++this.realSize;
        if (this.canAdd()) {
            this.lines.add(textSupplier.get());
        }
    }

    public void appendAll(List<? extends class_2561> newLines) {
        this.realSize += newLines.size();
        if (this.canAdd()) {
            for (class_2561 class_25612 : newLines) {
                this.lines.add(class_25612);
                if (this.canAdd()) continue;
                break;
            }
        }
    }

    public List<class_2561> build() {
        if (this.realSize > this.maxSize && HeldItemInfo.config.showHiddenLinesCount()) {
            class_5250 moreText = class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{this.realSize - this.maxSize + 1}).method_27695(new class_124[]{DEFAULT_COLOR, class_124.field_1056});
            this.lines.set(this.lines.size() - 1, (class_2561)moreText);
        }
        return this.lines;
    }
}

