/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.fluid;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class ResourcefulFlowingFluid
extends class_3609 {
    private final FluidData data;

    public ResourcefulFlowingFluid(FluidData data) {
        this.data = data;
    }

    @ApiStatus.Internal
    public FluidData getData() {
        return this.data;
    }

    @NotNull
    public class_3611 method_15750() {
        return (class_3611)this.data.flowing().get();
    }

    @NotNull
    public class_3611 method_15751() {
        return (class_3611)this.data.still().get();
    }

    protected boolean method_15737(class_3218 serverLevel) {
        return this.data.properties().canConvertToSource();
    }

    protected void method_15730(class_1936 level, class_2338 pos, class_2680 state) {
        class_2248.method_9610((class_2680)state, (class_1936)level, (class_2338)pos, state.method_31709() ? level.method_8321(pos) : null);
    }

    protected int method_15733(class_4538 levelReader) {
        return this.data.properties().slopeFindDistance();
    }

    protected int method_15739(class_4538 levelReader) {
        return this.data.properties().dropOff();
    }

    @NotNull
    public class_1792 method_15774() {
        return Objects.requireNonNullElse(this.data.bucket().get(), class_1802.field_8162);
    }

    protected boolean method_15777(class_3610 state, class_1922 level, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return direction == class_2350.field_11033 && !this.method_15780(fluid);
    }

    public int method_15789(class_4538 levelReader) {
        return this.data.properties().tickDelay();
    }

    protected float method_15784() {
        return this.data.properties().explosionResistance();
    }

    @NotNull
    protected class_2680 method_15790(class_3610 fluidState) {
        class_2248 block = (class_2248)this.data.block().get();
        if (block == null) {
            return class_2246.field_10124.method_9564();
        }
        return (class_2680)block.method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(ResourcefulFlowingFluid.method_15741((class_3610)fluidState)));
    }

    public boolean method_15780(class_3611 fluid) {
        return fluid == this.data.still().get() || fluid == this.data.flowing().get();
    }

    @NotNull
    public Optional<class_3414> method_32359() {
        return Optional.of(this.data.properties().sounds().getOrDefault("bucket_fill", class_3417.field_15126));
    }

    public static class Still
    extends ResourcefulFlowingFluid {
        public Still(FluidData data) {
            super(data);
            data.setStill(() -> this);
        }

        public int method_15779(class_3610 state) {
            return 8;
        }

        public boolean method_15793(class_3610 state) {
            return true;
        }
    }

    public static class Flowing
    extends ResourcefulFlowingFluid {
        public Flowing(FluidData data) {
            super(data);
            this.method_15781((class_3610)((class_3610)this.method_15783().method_11664()).method_11657((class_2769)field_15900, (Comparable)Integer.valueOf(7)));
            data.setFlowing(() -> this);
        }

        protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
            super.method_15775(builder);
            builder.method_11667(new class_2769[]{field_15900});
        }

        public boolean method_15793(class_3610 state) {
            return false;
        }

        public int method_15779(class_3610 state) {
            return (Integer)state.method_11654((class_2769)field_15900);
        }
    }
}

