/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.core;

import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.gui.UnsafeServerScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_639;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ServerSafetyState {
    private static final List<Runnable> RESET_ACTIONS = new ArrayList<Runnable>();
    private static final List<Runnable> SIGNING_ACTIONS = new ArrayList<Runnable>();
    private static final AtomicBoolean ALLOW_CHAT_SIGNING = new AtomicBoolean(false);
    private static volatile ServerSafetyLevel current = ServerSafetyLevel.UNDEFINED;
    private static volatile class_639 lastServer = null;
    private static volatile String lastMessage = "???";

    public static void updateCurrent(ServerSafetyLevel level) {
        current = level;
    }

    public static ServerSafetyLevel getCurrent() {
        return current;
    }

    public static boolean allowChatSigning() {
        return ALLOW_CHAT_SIGNING.get();
    }

    public static CompletableFuture<Void> setAllowChatSigning(boolean allow) {
        if (ALLOW_CHAT_SIGNING.compareAndSet(!allow, allow)) {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 != null) {
                class_634 connection = mc.field_1724.field_3944;
                if (allow && connection.field_40799 == null) {
                    return mc.method_43590().method_46522().thenAcceptAsync(optional -> optional.ifPresent(profileKeyPair -> {
                        connection.method_47657(profileKeyPair);
                        SIGNING_ACTIONS.forEach(Runnable::run);
                        SIGNING_ACTIONS.clear();
                    }), (Executor)mc);
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public static void toggleChatSigning() {
        ServerSafetyState.setAllowChatSigning(!ALLOW_CHAT_SIGNING.get());
    }

    public static boolean isOnRealms() {
        return current == ServerSafetyLevel.REALMS;
    }

    public static boolean isInSingleplayer() {
        return current == ServerSafetyLevel.SINGLEPLAYER;
    }

    public static boolean isDetermined() {
        return current != ServerSafetyLevel.UNINTRUSIVE && current != ServerSafetyLevel.UNDEFINED && current != ServerSafetyLevel.UNKNOWN;
    }

    @Nullable
    public static class_639 getLastServer() {
        return lastServer;
    }

    public static void setLastServer(@Nullable class_639 address) {
        lastServer = address;
    }

    public static String getLastMessage() {
        return lastMessage;
    }

    public static void setLastMessage(String message) {
        lastMessage = message;
    }

    public static void scheduleResetAction(Runnable action) {
        RESET_ACTIONS.add(action);
    }

    public static void scheduleSigningAction(Runnable action) {
        SIGNING_ACTIONS.add(action);
    }

    public static void reset() {
        lastServer = null;
        current = ServerSafetyLevel.UNDEFINED;
        ALLOW_CHAT_SIGNING.set(false);
        UnsafeServerScreen.setHideThisSession(false);
        RESET_ACTIONS.forEach(Runnable::run);
        RESET_ACTIONS.clear();
        SIGNING_ACTIONS.clear();
    }
}

