/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5223;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jspecify.annotations.Nullable;

public class ComponentDecomposer {
    private static final class_2583 EMPTY = class_2583.field_24360.method_36139(class_124.field_1068.method_532().intValue()).method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false));

    public static String toFormattedString(class_2561 component) {
        StringBuilder builder = new StringBuilder();
        component.method_27658((style, string) -> {
            builder.append(ComponentDecomposer.applyLegacyFormatting(string, style));
            return Optional.empty();
        }, class_2583.field_24360);
        return builder.toString();
    }

    private static String applyLegacyFormatting(String string, class_2583 style) {
        return ComponentDecomposer.toLegacyFormatting(style).stream().map(class_124::toString).reduce(String::concat).map(formats -> formats.concat(string).concat(class_124.field_1070.toString())).orElse(string);
    }

    private static List<class_124> toLegacyFormatting(class_2583 style) {
        class_124 chatFormatting;
        ArrayList<class_124> formats = new ArrayList<class_124>();
        if (style.method_10967()) {
            return formats;
        }
        class_5251 textColor = style.method_10973();
        if (textColor != null && (chatFormatting = class_124.method_533((String)textColor.toString())) != null) {
            formats.add(chatFormatting);
        }
        if (style.method_10984()) {
            formats.add(class_124.field_1067);
        }
        if (style.method_10966()) {
            formats.add(class_124.field_1056);
        }
        if (style.method_10965()) {
            formats.add(class_124.field_1073);
        }
        if (style.method_10986()) {
            formats.add(class_124.field_1055);
        }
        if (style.method_10987()) {
            formats.add(class_124.field_1051);
        }
        return ImmutableList.copyOf(formats);
    }

    public static class_2561 toFormattedComponent(@Nullable String value) {
        return (class_2561)ComponentDecomposer.toComponentEntries(value).stream().map(entry -> class_2561.method_43470((String)entry.getValue()).method_27696(entry.getStyle())).reduce(class_5250::method_10852).orElse(class_2561.method_43473());
    }

    public static String removeLast(@Nullable String value, int amount) {
        Deque<ComponentEntry> componentEntries = ComponentDecomposer.toComponentEntries(value);
        for (int i = 0; i < amount; ++i) {
            ComponentEntry componentEntry = componentEntries.peekLast();
            if (componentEntry == null) continue;
            if (!componentEntry.getValue().isEmpty()) {
                componentEntry.updateValue(s -> s.substring(0, s.length() - 1));
            }
            if (!componentEntry.getValue().isEmpty()) continue;
            componentEntries.pollLast();
        }
        return componentEntries.stream().map(entry -> ComponentDecomposer.applyLegacyFormatting(entry.getValue(), entry.getStyle())).collect(Collectors.joining());
    }

    private static Deque<ComponentEntry> toComponentEntries(@Nullable String value) {
        LinkedList<ComponentEntry> values = new LinkedList<ComponentEntry>();
        if (value == null) {
            return values;
        }
        AtomicBoolean resetStyle = new AtomicBoolean(true);
        class_5223.method_27479((String)value, (class_2583)EMPTY, (index, style, codePoint) -> {
            ComponentEntry last = (ComponentEntry)values.peekLast();
            if (last != null && last.getStyle().equals((Object)style)) {
                last.updateValue(s -> s + Character.toString(codePoint));
            } else {
                values.offerLast(new ComponentEntry(codePoint, style));
            }
            if (style != EMPTY) {
                resetStyle.set(false);
            }
            return true;
        });
        if (resetStyle.get()) {
            values.forEach(ComponentEntry::resetStyle);
        }
        return values;
    }

    public static int getStringLength(String value) {
        return ComponentDecomposer.toFormattedComponent(value).getString().length();
    }

    private static class ComponentEntry {
        private String value;
        private class_2583 style;

        public ComponentEntry(int codePoint, class_2583 style) {
            this.value = Character.toString(codePoint);
            this.style = style;
        }

        public String getValue() {
            return this.value;
        }

        public void updateValue(UnaryOperator<String> operator) {
            this.value = (String)operator.apply(this.value);
        }

        public class_2583 getStyle() {
            return this.style;
        }

        public void resetStyle() {
            this.style = class_2583.field_24360;
        }
    }
}

