/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils;

import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.handler.ItemInteractionHandler;
import fuzs.easyanvils.handler.NameTagDropHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.network.ClientboundAnvilRepairMessage;
import fuzs.easyanvils.network.ClientboundOpenNameTagEditorMessage;
import fuzs.easyanvils.network.client.ServerboundNameTagUpdateMessage;
import fuzs.easyanvils.network.client.ServerboundRenameItemMessage;
import fuzs.easyanvils.world.level.block.AnvilWithInventoryBlock;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.PayloadTypesContext;
import fuzs.puzzleslib.api.event.v1.AddBlockEntityTypeBlocksCallback;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyAnvils
implements ModConstructor {
    public static final String MOD_ID = "easyanvils";
    public static final String MOD_NAME = "Easy Anvils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Easy Anvils");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"easyanvils").client(ClientConfig.class).server(ServerConfig.class);
    public static final Predicate<class_2248> BLOCK_PREDICATE = block -> block instanceof class_2199 && !(block instanceof AnvilWithInventoryBlock);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        EasyAnvils.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        RegistryEntryAddedCallback.registryEntryAdded((class_5321)class_7924.field_41254).register(BlockConversionHandler.onRegistryEntryAdded(BLOCK_PREDICATE, AnvilWithInventoryBlock::new, MOD_ID));
        AddBlockEntityTypeBlocksCallback.EVENT.register((Object)BlockConversionHandler.onAddBlockEntityTypeBlocks(ModRegistry.ANVIL_BLOCK_ENTITY_TYPE));
        PlayerInteractEvents.USE_BLOCK.register((Object)BlockConversionHandler.onUseBlock(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG, class_3417.field_14559, () -> ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).convertVanillaAnvilWhenInteracting));
        TagsUpdatedCallback.EVENT.register(EventPhase.FIRST, (Object)BlockConversionHandler.onTagsUpdated(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG, BLOCK_PREDICATE));
        PlayerInteractEvents.USE_ITEM.register(ItemInteractionHandler::onUseItem);
        PlayerInteractEvents.USE_BLOCK.register(ItemInteractionHandler::onUseBlock);
        LivingDropsCallback.EVENT.register(NameTagDropHandler::onLivingDrops);
    }

    public void onCommonSetup() {
        class_2315.method_10009((class_1935)class_1802.field_8773, (class_2357)new class_2969(this){

            public class_1799 method_10135(class_2342 source, class_1799 itemStack) {
                if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilRepairing) {
                    return super.method_10135(source, itemStack);
                }
                class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 pos = source.comp_1968().method_10093(direction);
                class_3218 level = source.comp_1967();
                class_2680 state = level.method_8320(pos);
                this.method_27955(true);
                if (state.method_26164(class_3481.field_15486)) {
                    if (ItemInteractionHandler.tryRepairAnvil((class_1937)level, pos, state)) {
                        itemStack.method_7934(1);
                    } else {
                        this.method_27955(false);
                    }
                    return itemStack;
                }
                return super.method_10135(source, itemStack);
            }
        });
    }

    public void onRegisterPayloadTypes(PayloadTypesContext context) {
        context.playToClient(ClientboundAnvilRepairMessage.class, ClientboundAnvilRepairMessage.STREAM_CODEC);
        context.playToServer(ServerboundRenameItemMessage.class, ServerboundRenameItemMessage.STREAM_CODEC);
        context.playToClient(ClientboundOpenNameTagEditorMessage.class, ClientboundOpenNameTagEditorMessage.STREAM_CODEC);
        context.playToServer(ServerboundNameTagUpdateMessage.class, ServerboundNameTagUpdateMessage.STREAM_CODEC);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

