/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.player;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.Pose;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class}, priority=899)
public abstract class PlayerEntityMixin
implements PlayerAttackProperties,
EntityPlayer_BetterCombat {
    private int comboCount = 0;
    private Multimap<class_6880<class_1320>, class_1322> dualWieldingAttributeMap;
    private static final class_2960 dualWieldingSpeedModifierId = class_2960.method_60655((String)"bettercombat", (String)"dual_wield");

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    @Override
    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    public void post_Tick(CallbackInfo ci) {
        PlayerEntityMixin instance = this;
        class_1657 player = (class_1657)instance;
        if (player.method_73183().method_8608()) {
            ((PlayerAttackAnimatable)((Object)this)).updateAnimationsOnTick();
        } else {
            Pose pose = PlayerAttackHelper.poseForPlayer(player);
            Platform.playerAttachments().setMainHandIdleAnimation(player, pose.base());
            Platform.playerAttachments().setOffHandIdleAnimation(player, pose.offHand());
        }
        this.updateDualWieldingSpeedBoost();
    }

    @Override
    public String getMainHandIdleAnimation() {
        return Platform.playerAttachments().getMainHandIdleAnimation((class_1657)this);
    }

    @Override
    public String getOffHandIdleAnimation() {
        return Platform.playerAttachments().getOffHandIdleAnimation((class_1657)this);
    }

    @ModifyVariable(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at=@At(value="STORE"), ordinal=3)
    private boolean disableSweeping(boolean value) {
        if (BetterCombatMod.config.allow_vanilla_sweeping) {
            return value;
        }
        class_1657 player = (class_1657)this;
        AttackHand currentHand = PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
        if (currentHand != null) {
            return false;
        }
        return value;
    }

    private void updateDualWieldingSpeedBoost() {
        boolean currentState;
        class_1657 player = (class_1657)this;
        boolean newState = PlayerAttackHelper.isDualWielding(player);
        boolean bl = currentState = this.dualWieldingAttributeMap != null;
        if (newState != currentState) {
            if (newState) {
                this.dualWieldingAttributeMap = HashMultimap.create();
                double multiplier = BetterCombatMod.config.dual_wielding_attack_speed_multiplier - 1.0f;
                this.dualWieldingAttributeMap.put((Object)class_5134.field_23723, (Object)new class_1322(dualWieldingSpeedModifierId, multiplier, class_1322.class_1323.field_6330));
                player.method_6127().method_59932(this.dualWieldingAttributeMap);
            } else if (this.dualWieldingAttributeMap != null) {
                player.method_6127().method_59935(this.dualWieldingAttributeMap);
                this.dualWieldingAttributeMap = null;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_75201(ZZZ)Z"}, cancellable=true)
    public void canUseSweepAttack_HEAD(boolean cooldownPassed, boolean criticalHit, boolean knockback, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        AttackHand currentHand;
        if (!BetterCombatMod.config.allow_vanilla_sweeping && (currentHand = PlayerAttackHelper.getCurrentAttack(player = (class_1657)this, this.comboCount)) != null) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Override
    @Nullable
    public AttackHand getCurrentAttack() {
        if (this.comboCount < 0) {
            return null;
        }
        class_1657 player = (class_1657)this;
        return PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
    }
}

