/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranim.animation.PlayerAnimResources;
import com.zigythebird.playeranim.api.PlayerAnimationAccess;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import java.util.List;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.api.fx.ParticlePlacement;
import net.bettercombat.api.fx.TrailAppearance;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.animation.AttackAnimationStack;
import net.bettercombat.client.animation.FirstPersonHelper;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.animation.PoseAnimationStack;
import net.bettercombat.client.animation.TransmissionSpeedModifier;
import net.bettercombat.client.particle.SlashParticleUtil;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.Pose;
import net.bettercombat.mixin.player.LivingEntityAccessor;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements PlayerAttackAnimatable {
    private AttackAnimationStack attackAnimation;
    private PoseAnimationStack mainHandBodyPose;
    private PoseAnimationStack mainHandItemPose;
    private PoseAnimationStack offHandBodyPose;
    private PoseAnimationStack offHandItemPose;
    @Nullable
    private SlashParticleUtil.ScheduledSpawnArgs scheduledParticles = null;

    public AbstractClientPlayerEntityMixin(class_1937 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(method={"<init>(Lnet/minecraft/class_638;Lcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void postInit(class_638 world, GameProfile profile, CallbackInfo ci) {
        class_742 player = (class_742)this;
        this.attackAnimation = (AttackAnimationStack)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)player, (class_2960)AttackAnimationStack.ID);
        this.mainHandBodyPose = (PoseAnimationStack)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)player, (class_2960)PoseAnimationStack.MAIN_HAND_BODY_ID);
        this.mainHandItemPose = (PoseAnimationStack)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)player, (class_2960)PoseAnimationStack.MAIN_HAND_ITEM_ID);
        this.offHandBodyPose = (PoseAnimationStack)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)player, (class_2960)PoseAnimationStack.OFF_HAND_BODY_ID);
        this.offHandItemPose = (PoseAnimationStack)PlayerAnimationAccess.getPlayerAnimationLayer((class_11890)player, (class_2960)PoseAnimationStack.OFF_HAND_ITEM_ID);
    }

    @Override
    public void updateAnimationsOnTick() {
        AbstractClientPlayerEntityMixin instance = this;
        class_1657 player = instance;
        boolean isLeftHanded = this.isLeftHanded();
        boolean hasActiveAttackAnimation = this.attackAnimation.isActive();
        class_1799 mainHandStack = player.method_6047();
        if (this.scheduledParticles != null && this.scheduledParticles.time() == player.field_6012) {
            SlashParticleUtil.spawnParticles(this.scheduledParticles.args());
            this.scheduledParticles = null;
        }
        if (player.field_6252 || player.method_5681() || player.method_6115() || player.method_6101() || player.method_6128() || Platform.isCastingSpell(player) || class_1764.method_7781((class_1799)mainHandStack)) {
            this.mainHandBodyPose.setPose(null, isLeftHanded);
            this.mainHandItemPose.setPose(null, isLeftHanded);
            this.offHandBodyPose.setPose(null, isLeftHanded);
            this.offHandItemPose.setPose(null, isLeftHanded);
            return;
        }
        if (hasActiveAttackAnimation) {
            ((LivingEntityAccessor)player).invokeTurnHead(player.method_5791());
        }
        EntityPlayer_BetterCombat betterCombatPlayer = (EntityPlayer_BetterCombat)player;
        String newMainHandPoseId = null;
        String newOffHandPoseId = null;
        if (class_310.method_1551().field_1724 == player) {
            Pose pose = PlayerAttackHelper.poseForPlayer(player);
            if (!pose.base().isEmpty()) {
                newMainHandPoseId = pose.base();
            }
            if (!pose.offHand().isEmpty()) {
                newOffHandPoseId = pose.offHand();
            }
        } else {
            if (betterCombatPlayer.getMainHandIdleAnimation() != null && !betterCombatPlayer.getMainHandIdleAnimation().isEmpty()) {
                newMainHandPoseId = betterCombatPlayer.getMainHandIdleAnimation();
            }
            if (betterCombatPlayer.getOffHandIdleAnimation() != null && !betterCombatPlayer.getOffHandIdleAnimation().isEmpty()) {
                newOffHandPoseId = betterCombatPlayer.getOffHandIdleAnimation();
            }
        }
        this.mainHandItemPose.setPose(newMainHandPoseId, isLeftHanded);
        this.offHandItemPose.setPose(newOffHandPoseId, isLeftHanded);
        if (!PlayerAttackHelper.isTwoHandedWielding(player) && (this.isWalking() || this.method_5715())) {
            newMainHandPoseId = null;
            newOffHandPoseId = null;
        }
        this.mainHandBodyPose.setPose(newMainHandPoseId, isLeftHanded);
        this.offHandBodyPose.setPose(newOffHandPoseId, isLeftHanded);
    }

    @Override
    public void playAttackAnimation(String name, AnimatedHand animatedHand, float length, float upswing) {
        try {
            AttackAnimationStack controller = this.attackAnimation;
            Animation animation = PlayerAnimResources.getAnimation((class_2960)class_2960.method_60654((String)name));
            Float endTick = animation.data().get("endTick").orElse(Float.valueOf(animation.length()));
            float speed = endTick.floatValue() / length;
            boolean mirror = animatedHand.isOffHand();
            if (this.isLeftHanded()) {
                mirror = !mirror;
            }
            float upswingSpeed = speed / BetterCombatMod.config.getUpswingMultiplier();
            float downwindSpeed = (float)((double)speed * class_3532.method_16436((double)(Math.max((double)BetterCombatMod.config.getUpswingMultiplier() - 0.5, 0.0) / 0.5), (double)(1.0f - upswing), (double)(upswing / (1.0f - upswing))));
            FirstPersonConfiguration fistPersonConfig = this.firstPersonConfig(animatedHand);
            if (animatedHand == AnimatedHand.OFF_HAND) {
                fistPersonConfig = FirstPersonHelper.mirrored(fistPersonConfig);
            }
            controller.activeFirstPersonConfig = fistPersonConfig;
            controller.speed.speed = speed;
            controller.mirror.enabled = mirror;
            this.attackAnimation.speed.set(upswingSpeed, List.of(new TransmissionSpeedModifier.Gear(length * upswing, downwindSpeed), new TransmissionSpeedModifier.Gear(length, speed)));
            controller.triggerAnimation(animation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void playAttackParticles(boolean isOffHand, float weaponRange, int delay, List<ParticlePlacement> particles, TrailAppearance appearance) {
        class_742 player = (class_742)this;
        SlashParticleUtil.SpawnArgs spawn = new SlashParticleUtil.SpawnArgs(player, isOffHand, weaponRange, particles, appearance);
        this.scheduledParticles = new SlashParticleUtil.ScheduledSpawnArgs(spawn, player.field_6012 + delay);
    }

    private boolean isWalking() {
        return !this.method_29504() && (this.method_5681() || this.method_18798().method_37267() > 0.03);
    }

    public boolean isLeftHanded() {
        return this.method_6068() == class_1306.field_6182;
    }

    @Override
    public void stopAttackAnimation(float length) {
        this.scheduledParticles = null;
        if (this.attackAnimation.isActive()) {
            this.attackAnimation.stop();
        }
    }

    private FirstPersonConfiguration firstPersonConfig(AnimatedHand animatedHand) {
        boolean showRightItem = true;
        boolean showLeftItem = BetterCombatClientMod.config.isShowingOtherHandFirstPerson || animatedHand == AnimatedHand.TWO_HANDED;
        boolean showRightArm = showRightItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        boolean showLeftArm = showLeftItem && BetterCombatClientMod.config.isShowingArmsInFirstPerson;
        FirstPersonConfiguration config = new FirstPersonConfiguration(showRightArm, showLeftArm, showRightItem, showLeftItem);
        return config;
    }
}

