/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.ComboState;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.EntityAttributeHelper;
import net.bettercombat.logic.InventoryUtil;
import net.bettercombat.logic.Pose;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.utils.AttributeModifierHelper;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PlayerAttackHelper {
    private static final Object attributesLock = new Object();

    public static float getDualWieldingAttackDamageMultiplier(class_1657 player, AttackHand hand) {
        return PlayerAttackHelper.isDualWielding(player) ? (hand.isOffHand() ? BetterCombatMod.config.dual_wielding_off_hand_damage_multiplier : BetterCombatMod.config.dual_wielding_main_hand_damage_multiplier) : 1.0f;
    }

    public static boolean shouldAttackWithOffHand(class_1657 player, int comboCount) {
        return PlayerAttackHelper.isDualWielding(player) && comboCount % 2 == 1;
    }

    public static boolean isDualWielding(class_1657 player) {
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes(player.method_6047());
        WeaponAttributes offAttributes = WeaponRegistry.getAttributes(player.method_6079());
        return PlayerAttackHelper.isDualWielding(mainAttributes, offAttributes);
    }

    public static boolean isDualWielding(WeaponAttributes mainAttributes, WeaponAttributes offAttributes) {
        return mainAttributes != null && !mainAttributes.isTwoHanded() && offAttributes != null && !offAttributes.isTwoHanded();
    }

    public static boolean isTwoHandedWielding(class_1657 player) {
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes(player.method_6047());
        if (mainAttributes != null) {
            return mainAttributes.isTwoHanded();
        }
        return false;
    }

    public static float getAttackCooldownTicksCapped(class_1657 player) {
        return Math.max(player.method_7279(), (float)BetterCombatMod.config.attack_interval_cap);
    }

    @Nullable
    public static AttackHand getCurrentAttack(class_1657 player, int comboCount) {
        if (PlayerAttackHelper.isDualWielding(player)) {
            boolean isOffHand = PlayerAttackHelper.shouldAttackWithOffHand(player, comboCount);
            class_1799 itemStack = isOffHand ? player.method_6079() : player.method_6047();
            WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
            if (attributes != null && attributes.attacks() != null) {
                int handSpecificComboCount = (isOffHand && comboCount > 0 ? comboCount - 1 : comboCount) / 2;
                AttackSelection attackSelection = PlayerAttackHelper.selectAttack(handSpecificComboCount, attributes, player, isOffHand);
                if (attackSelection == null) {
                    return null;
                }
                WeaponAttributes.Attack attack = attackSelection.attack;
                ComboState combo = attackSelection.comboState;
                return new AttackHand(attack, combo, isOffHand, attributes, itemStack);
            }
        } else {
            class_1799 itemStack = player.method_6047();
            WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
            if (attributes != null && attributes.attacks() != null) {
                AttackSelection attackSelection = PlayerAttackHelper.selectAttack(comboCount, attributes, player, false);
                if (attackSelection == null) {
                    return null;
                }
                WeaponAttributes.Attack attack = attackSelection.attack;
                ComboState combo = attackSelection.comboState;
                return new AttackHand(attack, combo, false, attributes, itemStack);
            }
        }
        return null;
    }

    @Nullable
    private static AttackSelection selectAttack(int comboCount, WeaponAttributes attributes, class_1657 player, boolean isOffHandAttack) {
        WeaponAttributes.Attack[] attacks = attributes.attacks();
        attacks = (WeaponAttributes.Attack[])Arrays.stream(attacks).filter(attack -> attack.conditions() == null || attack.conditions().length == 0 || PlayerAttackHelper.evaluateConditions(attack.conditions(), player, isOffHandAttack)).toArray(WeaponAttributes.Attack[]::new);
        if (comboCount < 0) {
            comboCount = 0;
        }
        if (attacks.length == 0) {
            return null;
        }
        int index = comboCount % attacks.length;
        return new AttackSelection(attacks[index], new ComboState(index + 1, attacks.length));
    }

    private static boolean evaluateConditions(WeaponAttributes.Condition[] conditions, class_1657 player, boolean isOffHandAttack) {
        return Arrays.stream(conditions).allMatch(condition -> PlayerAttackHelper.evaluateCondition(condition, player, isOffHandAttack));
    }

    private static boolean evaluateCondition(WeaponAttributes.Condition condition, class_1657 player, boolean isOffHandAttack) {
        if (condition == null) {
            return true;
        }
        switch (condition) {
            case NOT_DUAL_WIELDING: {
                return !PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_ANY: {
                return PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_SAME: {
                return PlayerAttackHelper.isDualWielding(player) && player.method_6047().method_7909() == player.method_6079().method_7909();
            }
            case DUAL_WIELDING_SAME_CATEGORY: {
                if (!PlayerAttackHelper.isDualWielding(player)) {
                    return false;
                }
                WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(player.method_6047());
                WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(player.method_6079());
                if (mainHandAttributes.category() == null || mainHandAttributes.category().isEmpty() || offHandAttributes.category() == null || offHandAttributes.category().isEmpty()) {
                    return false;
                }
                return mainHandAttributes.category().equals(offHandAttributes.category());
            }
            case NO_OFFHAND_ITEM: {
                class_1799 offhandStack = player.method_6079();
                return offhandStack == null || offhandStack.method_7960();
            }
            case OFF_HAND_SHIELD: {
                class_1799 offhandStack = player.method_6079();
                return offhandStack != null || offhandStack.method_7909() instanceof class_1819;
            }
            case MAIN_HAND_ONLY: {
                return !isOffHandAttack;
            }
            case OFF_HAND_ONLY: {
                return isOffHandAttack;
            }
            case MOUNTED: {
                return player.method_5854() != null;
            }
            case NOT_MOUNTED: {
                return player.method_5854() == null;
            }
        }
        return true;
    }

    public static void swapHandAttributes(class_1657 player, Runnable runnable) {
        PlayerAttackHelper.swapHandAttributes(player, true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapHandAttributes(class_1657 player, boolean useOffHand, Runnable runnable) {
        if (!useOffHand) {
            runnable.run();
            return;
        }
        class_1657 class_16572 = player;
        synchronized (class_16572) {
            class_1661 inventory = player.method_31548();
            class_1799 mainHandStack = player.method_6047();
            class_1799 offHandStack = InventoryUtil.getOffHandSlotStack(player);
            PlayerAttackHelper.setAttributesForOffHandAttack(player, true);
            inventory.method_67531(offHandStack);
            InventoryUtil.setOffHandSlotStack(player, mainHandStack);
            runnable.run();
            inventory.method_67531(mainHandStack);
            InventoryUtil.setOffHandSlotStack(player, offHandStack);
            PlayerAttackHelper.setAttributesForOffHandAttack(player, false);
        }
    }

    private static void setAttributesForOffHandAttack(class_1657 player, boolean useOffHand) {
        Multimap<class_6880<class_1320>, class_1322> modifiersMap;
        class_1799 add;
        class_1799 remove;
        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();
        if (useOffHand) {
            remove = mainHandStack;
            add = offHandStack;
        } else {
            remove = offHandStack;
            add = mainHandStack;
        }
        if (remove != null) {
            modifiersMap = AttributeModifierHelper.modifierMultimap(remove);
            player.method_6127().method_59935(modifiersMap);
        }
        if (add != null) {
            modifiersMap = AttributeModifierHelper.modifierMultimap(add);
            player.method_6127().method_59932(modifiersMap);
        }
    }

    public static Pose poseForPlayer(class_1657 player) {
        class_1799 mainHandStack = player.method_6047();
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(mainHandStack);
        String mainPose = mainHandAttributes != null && mainHandAttributes.pose() != null ? mainHandAttributes.pose() : "";
        class_1799 offHandStack = player.method_6079();
        WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(offHandStack);
        String offPose = PlayerAttackHelper.isDualWielding(mainHandAttributes, offHandAttributes) && offHandAttributes != null && offHandAttributes.pose() != null ? offHandAttributes.pose() : "";
        return new Pose(mainPose, offPose);
    }

    public static double getStaticRange(class_1657 player, class_1799 stack) {
        WeaponAttributes attributes = WeaponRegistry.getAttributes(stack);
        return PlayerAttackHelper.combineAttackRange(attributes, player.method_45326(class_5134.field_47759));
    }

    public static double getRangeForItem(class_1657 player, class_1799 stack) {
        double interactionRangeValue = player.method_45325(class_5134.field_47759);
        return PlayerAttackHelper.getRangeWithItem(stack, interactionRangeValue);
    }

    public static double getRangeWithWeapon(class_1657 player, double interactionRangeValue) {
        return PlayerAttackHelper.getRangeWithItem(player.method_6047(), interactionRangeValue);
    }

    private static double getRangeWithItem(class_1799 stack, double interactionRangeValue) {
        if (EntityAttributeHelper.itemHasRangeAttribute(stack)) {
            return interactionRangeValue;
        }
        WeaponAttributes attributes = WeaponRegistry.getAttributes(stack);
        return PlayerAttackHelper.combineAttackRange(attributes, interactionRangeValue);
    }

    public static double combineAttackRange(WeaponAttributes attributes, double interactionRangeValue) {
        double range = interactionRangeValue;
        if (attributes != null) {
            if (attributes.attackRange() != 0.0) {
                return attributes.attackRange();
            }
            range += attributes.rangeBonus();
        }
        return range;
    }

    private record AttackSelection(WeaponAttributes.Attack attack, ComboState comboState) {
    }
}

