/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.fabric.network;

import java.util.function.Consumer;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.network.Packets;
import net.bettercombat.network.ServerNetwork;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_8710;

public class FabricServerNetwork {
    public static void init() {
        PayloadTypeRegistry.configurationS2C().register(Packets.ConfigSync.PACKET_ID, Packets.ConfigSync.CODEC);
        PayloadTypeRegistry.configurationS2C().register(Packets.WeaponRegistrySync.PACKET_ID, Packets.WeaponRegistrySync.CODEC);
        PayloadTypeRegistry.configurationC2S().register(Packets.Ack.PACKET_ID, Packets.Ack.CODEC);
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.ConfigSync.ID)) {
                String configJson = Packets.ConfigSync.serialize(BetterCombatMod.getConfig());
                handler.addTask((class_8605)new ConfigurationTask(configJson));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: bettercombat:config"));
            }
        });
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)Packets.WeaponRegistrySync.ID)) {
                if (WeaponRegistry.getEncodedRegistry().chunks().isEmpty()) {
                    throw new AssertionError((Object)"Weapon registry is empty!");
                }
                handler.addTask((class_8605)new WeaponRegistrySyncTask(WeaponRegistry.getEncodedRegistry()));
            } else {
                handler.method_52396((class_2561)class_2561.method_43470((String)"Network configuration task not supported: bettercombat:weapon_registry"));
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver(Packets.Ack.PACKET_ID, (packet, context) -> {
            if (packet.code().equals("bettercombat:config")) {
                context.networkHandler().completeTask(ConfigurationTask.KEY);
            }
            if (packet.code().equals("bettercombat:weapon_registry")) {
                context.networkHandler().completeTask(WeaponRegistrySyncTask.KEY);
            }
        });
        PayloadTypeRegistry.playS2C().register(Packets.AttackSound.PACKET_ID, Packets.AttackSound.CODEC);
        PayloadTypeRegistry.playS2C().register(Packets.AttackAnimation.PACKET_ID, Packets.AttackAnimation.CODEC);
        PayloadTypeRegistry.playC2S().register(Packets.AttackAnimation.PACKET_ID, Packets.AttackAnimation.CODEC);
        PayloadTypeRegistry.playC2S().register(Packets.C2S_AttackRequest.PACKET_ID, Packets.C2S_AttackRequest.CODEC);
        PayloadTypeRegistry.playC2S().register(Packets.C2S_BlockHit.PACKET_ID, Packets.C2S_BlockHit.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(Packets.AttackAnimation.PACKET_ID, (packet, context) -> ServerNetwork.handleAttackAnimation(packet, context.server(), context.player()));
        ServerPlayNetworking.registerGlobalReceiver(Packets.C2S_AttackRequest.PACKET_ID, (packet, context) -> ServerNetwork.handleAttackRequest(packet, context.server(), context.player(), context.player().field_13987));
        ServerPlayNetworking.registerGlobalReceiver(Packets.C2S_BlockHit.PACKET_ID, (packet, context) -> ServerNetwork.handleBlockHit(packet, context.server(), context.player()));
    }

    public record ConfigurationTask(String configString) implements class_8605
    {
        public static final String name = "bettercombat:config";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("bettercombat:config");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            Packets.ConfigSync packet = new Packets.ConfigSync(this.configString);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)packet));
        }
    }

    public record WeaponRegistrySyncTask(WeaponRegistry.Encoded encodedRegistry) implements class_8605
    {
        public static final String name = "bettercombat:weapon_registry";
        public static final class_8605.class_8606 KEY = new class_8605.class_8606("bettercombat:weapon_registry");

        public class_8605.class_8606 method_52375() {
            return KEY;
        }

        public void method_52376(Consumer<class_2596<?>> sender) {
            Packets.WeaponRegistrySync packet = new Packets.WeaponRegistrySync(this.encodedRegistry.compressed(), this.encodedRegistry.chunks());
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)packet));
        }
    }
}

