/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.animation;

import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.AnimationController;
import com.zigythebird.playeranimcore.animation.layered.ModifierLayer;
import com.zigythebird.playeranimcore.animation.layered.modifier.AbstractModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.AdjustmentModifier;
import com.zigythebird.playeranimcore.animation.layered.modifier.MirrorModifier;
import com.zigythebird.playeranimcore.api.firstPerson.FirstPersonConfiguration;
import com.zigythebird.playeranimcore.bones.AdvancedPlayerAnimBone;
import com.zigythebird.playeranimcore.math.Vec3f;
import java.util.Optional;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.client.animation.TransmissionSpeedModifier;
import net.bettercombat.client.compat.FirstPersonAnimationCompatibility;
import net.minecraft.class_11890;
import net.minecraft.class_2960;
import net.minecraft.class_4050;

public class AttackAnimationStack
extends PlayerAnimationController {
    public static final class_2960 ID = class_2960.method_60655((String)"bettercombat", (String)"attack");
    public final TransmissionSpeedModifier speed = new TransmissionSpeedModifier(1.0f);
    public final MirrorModifier mirror = new MirrorModifier();
    public final ModifierLayer base = new ModifierLayer(null, new AbstractModifier[0]);
    public FirstPersonConfiguration activeFirstPersonConfig = new FirstPersonConfiguration();

    public AttackAnimationStack(class_11890 entity, AnimationController.AnimationStateHandler animationHandler) {
        super(entity, animationHandler);
        this.postInit();
    }

    private void postInit() {
        this.addModifier((AbstractModifier)this.mirror, 0);
        this.addModifier((AbstractModifier)this.speed, 0);
        this.addModifierLast((AbstractModifier)this.createAttackAdjustment());
        this.firstPersonMode = controller -> FirstPersonAnimationCompatibility.firstPersonMode();
        this.firstPersonConfiguration = controller -> this.activeFirstPersonConfig;
        this.setPostAnimationSetupConsumer(func -> {
            float legAnimationThreshold;
            ((AdvancedPlayerAnimBone)func.apply("torso")).setEnabled(true);
            ((AdvancedPlayerAnimBone)func.apply("head")).rotXEnabled = false;
            class_11890 player = this.getAvatar();
            class_4050 pose = player.method_18376();
            boolean disableLegs = false;
            if (pose == class_4050.field_18079) {
                disableLegs = true;
            }
            if (player.method_5854() != null) {
                disableLegs = true;
            }
            if (!disableLegs && (legAnimationThreshold = BetterCombatClientMod.config.legAnimationThreshold) > 0.0f) {
                boolean moving;
                boolean bl = moving = player.method_5624() || AttackAnimationStack.isWalking(player);
                if (moving && player.method_18798().method_37268() > (double)(legAnimationThreshold * legAnimationThreshold)) {
                    disableLegs = true;
                }
            }
            if (disableLegs) {
                ((AdvancedPlayerAnimBone)func.apply("right_leg")).setEnabled(false);
                ((AdvancedPlayerAnimBone)func.apply("left_leg")).setEnabled(false);
            }
        });
    }

    private AdjustmentModifier createAttackAdjustment() {
        return new AdjustmentModifier((partName, data) -> {
            class_11890 player = this.getAvatar();
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            float pitch = player.method_36455();
            if (data.isFirstPersonPass()) {
                pitch = (float)Math.toRadians(pitch);
                if (!partName.equals("body")) return Optional.empty();
                rotationX += pitch;
                if (!(pitch < 0.0f)) return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
                double offset = Math.abs(Math.sin(pitch));
                offsetY = (float)((double)offsetY + offset * 0.5);
                offsetZ = (float)((double)offsetZ - offset);
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
            } else {
                pitch = (float)Math.toRadians(pitch);
                if (partName.equals("body")) {
                    rotationX += pitch * 0.75f;
                    return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
                } else if (this.isArm((String)partName)) {
                    rotationX += pitch * 0.25f;
                    return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
                } else {
                    if (!this.isLeg((String)partName)) return Optional.empty();
                    rotationX = (float)((double)rotationX - (double)pitch * 0.75);
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private boolean isArm(String partName) {
        return partName.equals("right_arm") || partName.equals("left_arm");
    }

    private boolean isLeg(String partName) {
        return partName.equals("right_leg") || partName.equals("left_leg");
    }

    private static boolean isWalking(class_11890 player) {
        return !player.method_29504() && (player.method_5681() || player.method_18798().method_37267() > 0.03);
    }
}

