/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class Random {
    static DecimalFormat df = new DecimalFormat("#.##");
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LRandom:\u00a7r\u00a7f\n    Given a maximum and/or minimum value, returns a random number between those values \u00a77(inclusive)\u00a7r. If just a maximum value is entered, picks a random number from 0 to the max value \u00a77(inclusive)\u00a7r.\n    \u00a7eUsage: /calc random <max>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"random").then(ClientCommandManager.argument((String)"max", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Random.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"max"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).then(ClientCommandManager.literal((String)"minmax").then(ClientCommandManager.argument((String)"min", (ArgumentType)StringArgumentType.string()).then(ClientCommandManager.argument((String)"max", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Random.execute(((FabricClientCommandSource)ctx.getSource()).getEntity(), StringArgumentType.getString((CommandContext)ctx, (String)"min"), StringArgumentType.getString((CommandContext)ctx, (String)"max"));
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("random");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"random").then(class_2170.method_9244((String)"max", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Random.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"max"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).then(class_2170.method_9247((String)"minmax").then(class_2170.method_9244((String)"min", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"max", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CalcMessageBuilder message = Random.execute(((class_2168)ctx.getSource()).method_9228(), StringArgumentType.getString((CommandContext)ctx, (String)"min"), StringArgumentType.getString((CommandContext)ctx, (String)"max"));
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("random");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_1297 player, String ... range) {
        if (range.length == 1) {
            double maxInt = CalcCommand.getParsedExpression(player, range[0], new Integer[0]);
            String random = nf.format(ThreadLocalRandom.current().nextInt(0, (int)maxInt + 1));
            return new CalcMessageBuilder().addFromArray(new String[]{"Random number between 0 and ", "input", " \u00a77(inclusive)\u00a7f = ", "result"}, range, new String[]{random});
        }
        if (range.length == 2) {
            double max = CalcCommand.getParsedExpression(player, range[1], new Integer[0]);
            double min = CalcCommand.getParsedExpression(player, range[0], new Integer[0]);
            String random = nf.format(ThreadLocalRandom.current().nextInt((int)min, (int)max + 1));
            return new CalcMessageBuilder().addFromArray(new String[]{"Random number between ", "input", " and ", "input", " \u00a77(inclusive)\u00a7f = ", "result"}, range, new String[]{random});
        }
        return new CalcMessageBuilder("Invalid Arguments");
    }
}

