/*
 * Decompiled with CFR 0.152.
 */
package net.jsa2025.calcmod.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.xpple.clientarguments.arguments.CBlockPosArgument;
import java.text.NumberFormat;
import java.util.Locale;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.jsa2025.calcmod.commands.CalcCommand;
import net.jsa2025.calcmod.commands.subcommands.Help;
import net.jsa2025.calcmod.utils.CalcMessageBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;

public class Distance {
    static NumberFormat nf = NumberFormat.getInstance(new Locale("en", "US"));
    public static String helpMessage = "\u00a7b\u00a7LDistance:\u00a7r\u00a7f\n    Given two block positions, gives distance between them. If only one position is given, uses player's location. The 3D mode provides distance including height.\n    \u00a7eUsage: /calc dist <x1> <y1> <z1>\u00a7f\n    \u00a7eUsage: /calc dist <x1> <y1> <z1> <x2> <y2> <z2>\u00a7f\n    \u00a7eUsage: /calc dist 3d <x1> <y1> <z1>\u00a7f\n    \u00a7eUsage: /calc dist 3d <x1> <y1> <z1> <x2> <y2> <z2>\u00a7f\n";

    public static LiteralArgumentBuilder<FabricClientCommandSource> register(LiteralArgumentBuilder<FabricClientCommandSource> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dist").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos1", (ArgumentType)CBlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"pos2", (ArgumentType)CBlockPosArgument.blockPos()).executes(ctx -> {
            class_2338 pos1 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1");
            class_2338 pos2 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos2");
            CalcMessageBuilder message = Distance.execute(pos1, pos2);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).executes(ctx -> {
            class_2338 pos1 = ((FabricClientCommandSource)ctx.getSource()).getPlayer().method_24515();
            class_2338 pos2 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1");
            CalcMessageBuilder message = Distance.execute(pos1, pos2);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).then(ClientCommandManager.literal((String)"3d").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos1", (ArgumentType)CBlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"pos2", (ArgumentType)CBlockPosArgument.blockPos()).executes(ctx -> {
            class_2338 pos1 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1");
            class_2338 pos2 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos2");
            CalcMessageBuilder message = Distance.execute3d(pos1, pos2);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        }))).executes(ctx -> {
            class_2338 pos1 = ((FabricClientCommandSource)ctx.getSource()).getPlayer().method_24515();
            class_2338 pos2 = CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos1");
            CalcMessageBuilder message = Distance.execute3d(pos1, pos2);
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("dist");
            CalcCommand.sendMessage((FabricClientCommandSource)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static LiteralArgumentBuilder<class_2168> registerServer(LiteralArgumentBuilder<class_2168> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dist").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos1", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"pos2", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            class_2338 pos1 = class_2262.method_48299((CommandContext)ctx, (String)"pos1");
            class_2338 pos2 = class_2262.method_48299((CommandContext)ctx, (String)"pos2");
            CalcMessageBuilder message = Distance.execute(pos1, pos2);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).executes(ctx -> {
            class_2338 pos1 = ((class_2168)ctx.getSource()).method_44023().method_24515();
            class_2338 pos2 = class_2262.method_48299((CommandContext)ctx, (String)"pos1");
            CalcMessageBuilder message = Distance.execute(pos1, pos2);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).then(class_2170.method_9247((String)"3d").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos1", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"pos2", (ArgumentType)class_2262.method_9698()).executes(ctx -> {
            class_2338 pos1 = class_2262.method_48299((CommandContext)ctx, (String)"pos1");
            class_2338 pos2 = class_2262.method_48299((CommandContext)ctx, (String)"pos2");
            CalcMessageBuilder message = Distance.execute3d(pos1, pos2);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        }))).executes(ctx -> {
            class_2338 pos1 = ((class_2168)ctx.getSource()).method_44023().method_24515();
            class_2338 pos2 = class_2262.method_48299((CommandContext)ctx, (String)"pos1");
            CalcMessageBuilder message = Distance.execute3d(pos1, pos2);
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            CalcMessageBuilder message = Help.execute("dist");
            CalcCommand.sendMessageServer((class_2168)ctx.getSource(), message);
            return 1;
        })));
        return command;
    }

    public static CalcMessageBuilder execute(class_2338 pos1, class_2338 pos2) {
        double dist = Math.sqrt(Math.pow(pos1.method_10263() - pos2.method_10263(), 2.0) + Math.pow(pos1.method_10260() - pos2.method_10260(), 2.0));
        CalcMessageBuilder message = new CalcMessageBuilder().addString("Distance from ").addInput("X: " + pos1.method_10263() + " Z: " + pos1.method_10260()).addString(" to ").addInput("X: " + pos2.method_10263() + " Z: " + pos2.method_10260()).addString(": ").addResult(String.valueOf(nf.format(dist)));
        return message;
    }

    public static CalcMessageBuilder execute3d(class_2338 pos1, class_2338 pos2) {
        double dist = Math.sqrt(Math.pow(pos1.method_10263() - pos2.method_10263(), 2.0) + Math.pow(pos1.method_10264() - pos2.method_10264(), 2.0) + Math.pow(pos1.method_10260() - pos2.method_10260(), 2.0));
        CalcMessageBuilder message = new CalcMessageBuilder().addString("Distance from ").addInput("X: " + pos1.method_10263() + " Y: " + pos1.method_10264() + " Z: " + pos1.method_10260()).addString(" to ").addInput("X: " + pos2.method_10263() + " Y: " + pos2.method_10264() + " Z: " + pos2.method_10260()).addString(": ").addResult(String.valueOf(nf.format(dist)));
        return message;
    }
}

