/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.DataProviderRegistry;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4588;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_765;

public class Compute {
    private static class_4076 playerPos = class_4076.method_18676((int)0, (int)0, (int)0);
    private static final Object2ObjectOpenHashMap<class_4076, BufferHolder> cachedBuffers = new Object2ObjectOpenHashMap();
    private static final TreeSet<class_4076> toBeUpdated = new TreeSet<class_4076>(Comparator.comparingDouble(self -> {
        int manhattanDistance = self.method_19455((class_2382)playerPos);
        double tieBreaker = (double)self.method_18694() / 9.223372036854776E18;
        return (double)manhattanDistance + tieBreaker;
    }));
    static int computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + 1);

    private static boolean outOfRange(class_4076 sPos) {
        return Compute.outOfRange(sPos, playerPos);
    }

    public static boolean outOfRange(class_4076 one, class_4076 two) {
        int absX = Math.abs(one.method_18674() - two.method_18674());
        int absZ = Math.abs(one.method_18687() - two.method_18687());
        return absX > computationDistance || absZ > computationDistance;
    }

    public static void clear() {
        toBeUpdated.clear();
        cachedBuffers.values().forEach(BufferHolder::close);
        cachedBuffers.clear();
        computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)class_310.method_1551().field_1690.method_42503().method_41753() + 1);
    }

    public static void updateBlockPos(class_2338 pos) {
        class_4076 sPos = class_4076.method_18682((class_2338)pos);
        if (sPos.method_19528() == pos.method_10264()) {
            Compute.updateSection(sPos.method_34591(0, -1, 0));
        }
        Compute.updateSection(sPos);
    }

    public static void updateSection(class_4076 sPos) {
        if (Compute.outOfRange(sPos) || !class_310.method_1551().field_1769.method_40050(sPos.method_19767())) {
            return;
        }
        toBeUpdated.add(sPos);
    }

    private static BufferHolder buildChunk(OverlayRenderer renderer, List<OverlayDataProvider> dataProviders, class_4076 sPos, class_638 level, BufferHolder buffer) {
        class_2338 sectionOrigin = sPos.method_19767();
        class_2818 computationChunk = level.method_8500(sectionOrigin);
        for (OverlayDataProvider dataProvider : dataProviders) {
            ObjectArrayList dataList = null;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2338 pos = sectionOrigin.method_10069(x, y, z);
                        OverlayData data = dataProvider.compute(level, computationChunk, pos, new class_2382(x, y, z));
                        if (!data.valid()) continue;
                        if (dataList == null) {
                            dataList = new ObjectArrayList(300);
                        }
                        dataList.add((Object)data);
                    }
                }
            }
            if (dataList == null) {
                buffer.invalidateBuffer(dataProvider.getIdentifier());
                continue;
            }
            class_287 builder = class_289.method_1348().method_60827(renderer.getVertexFormatMode(), renderer.getVertexFormat());
            int overlayBrightness = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
            int lightmap = class_765.method_23687((int)overlayBrightness, (int)overlayBrightness);
            for (OverlayData data : dataList) {
                renderer.build(level, data.pos(), data, (class_4588)builder, lightmap);
            }
            buffer.upload(builder.method_60794(), dataProvider.getIdentifier());
        }
        return buffer;
    }

    @Deprecated
    private static void queueNewChunksSlow(class_1937 level, class_761 levelRenderer) {
        Compute.queueNewChunksSlow(level, levelRenderer, null);
    }

    private static void queueNewChunksSlow(class_1937 level, class_761 levelRenderer, class_4604 frustum) {
        for (int yy = level.method_32891(); yy < level.method_32890() + level.method_32891(); ++yy) {
            for (int xx = -computationDistance; xx <= computationDistance; ++xx) {
                for (int zz = -computationDistance; zz <= computationDistance; ++zz) {
                    class_4076 chunkSection = class_4076.method_18676((int)(playerPos.method_18674() + xx), (int)yy, (int)(playerPos.method_18687() + zz));
                    class_2338 sectionOrigin = chunkSection.method_19767();
                    class_238 chunkBoundaries = class_238.method_54784((class_2338)sectionOrigin.method_10069(-1, -1, -1), (class_2338)sectionOrigin.method_10069(16, 16, 16));
                    if (frustum != null && !frustum.method_23093(chunkBoundaries) || cachedBuffers.containsKey((Object)chunkSection) || !levelRenderer.method_40050(chunkSection.method_19767())) continue;
                    toBeUpdated.add(chunkSection);
                }
            }
        }
    }

    public static Object2ObjectOpenHashMap<class_4076, BufferHolder> computeCache(class_2338 cameraPos, class_1937 level, class_761 levelRenderer, class_4604 frustum) {
        class_4076 sectionPos;
        playerPos = class_4076.method_18682((class_2338)cameraPos);
        if (!SMACH.isEnabled()) {
            return null;
        }
        Compute.queueNewChunksSlow(level, levelRenderer, frustum);
        List<OverlayDataProvider> dataProviders = DataProviderRegistry.getActiveProviders();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        ObjectIterator cacheIterator = cachedBuffers.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            if (!Compute.outOfRange((class_4076)entry.getKey())) continue;
            ((BufferHolder)entry.getValue()).close();
            cacheIterator.remove();
        }
        int ii = level.method_32890() * (Integer)Config.CHUNKS_PER_TICK.getValue();
        while (ii > 0 && (sectionPos = toBeUpdated.pollFirst()) != null) {
            if (Compute.outOfRange(sectionPos)) continue;
            --ii;
            cachedBuffers.compute((Object)sectionPos, (pos, bufferHolder) -> Compute.buildChunk(renderer, dataProviders, pos, (class_638)level, bufferHolder != null ? bufferHolder : new BufferHolder()));
        }
        return cachedBuffers;
    }

    private Compute() {
    }
}

