/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.File;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private ProfilerWrapper profilerWrapper;

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.hasSingleplayerServer();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.getCurrentServer() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return MINECRAFT.getCurrentServer() == null && !this.hasSinglePlayerServer();
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.name : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.ip : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.version.getString() : "UNKOWN";
    }

    public LocalPlayer getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.player;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.player != null;
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhBlockPos(0, 0, 0);
        }
        BlockPos playerPos = player.blockPosition();
        return new DhBlockPos(playerPos.getX(), playerPos.getY(), playerPos.getZ());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhChunkPos(0, 0);
        }
        ChunkPos playerPos = player.chunkPosition();
        return new DhChunkPos(playerPos.x, playerPos.z);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        return this.getWrappedClientLevel(false);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel(boolean bypassLevelKeyManager) {
        ClientLevel level = MinecraftClientWrapper.MINECRAFT.level;
        if (level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(level, bypassLevelKeyManager);
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        GLProxy.queueRunningOnRenderThread(() -> player.displayClientMessage((Component)Component.translatable((String)string), false));
    }

    @Override
    public void sendOverlayMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)string), true);
    }

    @Override
    public void disableVanillaClouds() {
        MinecraftClientWrapper.MINECRAFT.options.cloudStatus().set((Object)CloudStatus.OFF);
    }

    @Override
    public void disableVanillaChunkFadeIn() {
        MinecraftClientWrapper.MINECRAFT.options.chunkSectionFadeInTime().set((Object)0.0);
    }

    @Override
    public IProfilerWrapper getProfiler() {
        ProfilerFiller profiler = Profiler.get();
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(profiler);
        } else if (profiler != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = profiler;
        }
        return this.profilerWrapper;
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.fatal("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        MINECRAFT.delayCrash(report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.options;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.gameDirectory;
    }

    @Override
    public int getPlayerCount() {
        if (MINECRAFT.getSingleplayerServer() == null) {
            return 1;
        }
        return MINECRAFT.getSingleplayerServer().getPlayerCount();
    }
}

