/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.level.DhServerLevel;
import com.seibel.distanthorizons.core.world.AbstractDhServerWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import org.jetbrains.annotations.NotNull;

public class DhServerWorld
extends AbstractDhServerWorld<DhServerLevel> {
    public DhServerWorld() {
        super(EWorldEnvironment.SERVER_ONLY);
        LOGGER.info("Started [" + DhServerWorld.class.getSimpleName() + "] of type [" + (Object)((Object)this.environment) + "].", new Object[0]);
    }

    @Override
    public DhServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return null;
        }
        return this.dhLevelByLevelWrapper.computeIfAbsent(wrapper, serverLevelWrapper -> {
            try {
                return new DhServerLevel(this.saveStructure, (IServerLevelWrapper)serverLevelWrapper, this.getServerPlayerStateManager());
            }
            catch (Exception e) {
                LOGGER.fatal("Failed to load server level, error: [" + e.getMessage() + "].", e);
                ClientApi.INSTANCE.showChatMessageNextFrame("\u00a7cDistant Horizons: Server level loading failed.\u00a7r \nUnable to load level [" + serverLevelWrapper.getDhIdentifier() + "], LODs may not appear. See log for more information.");
                return null;
            }
        });
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IServerLevelWrapper)) {
            return;
        }
        if (this.dhLevelByLevelWrapper.containsKey(wrapper)) {
            DhServerLevel level = (DhServerLevel)this.dhLevelByLevelWrapper.get(wrapper);
            wrapper.onUnload();
            ((DhServerLevel)this.dhLevelByLevelWrapper.remove(wrapper)).close();
        }
    }
}

