/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.services;

import com.natamus.collective_common_neoforge.data.ClientConstants;
import com.natamus.collective_common_neoforge.services.helpers.RegisterKeyMappingHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import org.jetbrains.annotations.Nullable;

public class NeoForgeRegisterKeyMappingHelper
implements RegisterKeyMappingHelper {
    private static final List<KeyMapping> keyMappingsToRegister = new ArrayList<KeyMapping>();

    @Override
    @Nullable
    public KeyMapping registerKeyMapping(String description, int key, String category) {
        if (!ClientConstants.keyMappingCategories.containsKey(category)) {
            return null;
        }
        return this.registerKeyMapping(description, key, ClientConstants.keyMappingCategories.get(category));
    }

    @Override
    public KeyMapping registerKeyMapping(String description, int key, KeyMapping.Category keyMappingCategory) {
        KeyMapping keyMapping = new KeyMapping(description, key, keyMappingCategory);
        keyMappingsToRegister.add(keyMapping);
        return keyMapping;
    }

    public static void registerKeyMappings(RegisterKeyMappingsEvent e) {
        for (KeyMapping keyMapping : keyMappingsToRegister) {
            e.register(keyMapping);
        }
    }
}

