/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_3544;
import net.minecraft.class_4081;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.JadeMobEffectInstance;

public class StatusEffectsProvider
implements StreamServerDataProvider<EntityAccessor, List<Effect>> {
    public static final StatusEffectsProvider INSTANCE = new StatusEffectsProvider();
    private static final class_9139<class_9129, List<Effect>> STREAM_CODEC = class_9135.method_56363().apply(Effect.STREAM_CODEC);

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        return accessor.getEntity() instanceof class_1309;
    }

    @Override
    public @Nullable List<Effect> streamData(EntityAccessor accessor) {
        List<Effect> effects = ((class_1309)accessor.getEntity()).method_6026().stream().filter(class_1293::method_5581).filter(Predicate.not(WailaCommonRegistration.instance().mobEffectOperations()::shouldHide)).map(Effect::new).toList();
        return effects.isEmpty() ? null : effects;
    }

    @Override
    public class_9139<class_9129, List<Effect>> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_POTION_EFFECTS;
    }

    public record Effect(class_1293 effect, long updateTime, long addTime) implements Comparable<Effect>
    {
        public static final class_9139<class_9129, Effect> STREAM_CODEC = class_9139.method_56436((class_9139)class_1293.field_49207, Effect::effect, (class_9139)class_9135.field_54505, Effect::updateTime, (class_9139)class_9135.field_54505, Effect::addTime, Effect::new);

        public Effect(class_1293 effect) {
            this(effect, ((JadeMobEffectInstance)effect).jade$updateTime(), ((JadeMobEffectInstance)effect).jade$addTime());
        }

        @Override
        public int compareTo(Effect o) {
            int compared = Long.compare(this.updateTime, o.updateTime);
            if (compared != 0) {
                return -compared;
            }
            return this.effect.method_5587(o.effect);
        }
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();
        public static final class_2561 INFINITE = class_2561.method_43471((String)"effect.duration.infinite");

        public static class_5250 getEffectName(class_1293 mobEffectInstance) {
            class_5250 mutableComponent = ((class_1291)mobEffectInstance.method_5579().comp_349()).method_5560().method_27661();
            if (mobEffectInstance.method_5578() >= 1) {
                class_5250 level = class_2561.method_43471((String)("enchantment.level." + (mobEffectInstance.method_5578() + 1)));
                if (!class_2564.method_43476((class_2561)level)) {
                    level = class_2561.method_43470((String)Integer.toString(mobEffectInstance.method_5578() + 1));
                }
                mutableComponent.method_10852(class_5244.field_41874).method_10852((class_2561)level);
            }
            return mutableComponent;
        }

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            List<Object> effects = INSTANCE.decodeFromData(accessor).orElse(List.of());
            if (effects.isEmpty()) {
                return;
            }
            ITooltip box = JadeUI.tooltip();
            IThemeHelper t = IThemeHelper.get();
            long current = System.currentTimeMillis();
            float scale = (effects = effects.stream().filter($ -> {
                if (WailaCommonRegistration.instance().mobEffectOperations().shouldHide($.effect())) {
                    return false;
                }
                long ms = current - $.addTime() - 20L;
                return ms > 0L;
            }).sorted().limit(config.getInt(JadeIds.MC_POTION_EFFECTS_LIMIT)).toList()).size() > 2 ? 0.75f : 1.0f;
            boolean animation = IWailaConfig.get().overlay().getAnimation();
            for (Effect data : effects) {
                long ms = current - data.addTime() - 20L;
                float alpha = 1.0f;
                if (animation && ms < 480L) {
                    alpha = (float)ms / 480.0f;
                }
                class_1293 effect = data.effect();
                class_5250 name = Client.getEffectName(effect);
                String duration = effect.method_48559() ? INFINITE.getString() : class_3544.method_15439((int)effect.method_5584(), (float)accessor.tickRate());
                class_5250 s = class_2561.method_43469((String)"jade.potion", (Object[])new Object[]{name, duration});
                s = switch (((class_1291)effect.method_5579().comp_349()).method_18792()) {
                    default -> throw new MatchException(null, null);
                    case class_4081.field_18271 -> t.success(s);
                    case class_4081.field_18272 -> t.danger(s);
                    case class_4081.field_18273 -> t.info(s);
                };
                box.add(JadeUI.text((class_2561)s).scale(scale).alpha(alpha));
            }
            tooltip.add(JadeUI.box(box, BoxStyle.nestedBox()).flexGrow(1));
        }

        @Override
        public class_2960 getUid() {
            return JadeIds.MC_POTION_EFFECTS;
        }
    }
}

