/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10583;
import net.minecraft.class_11560;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6025;
import net.minecraft.class_7497;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.util.ClientProxy;

public class AnimalOwnerProvider
implements StreamServerDataProvider<EntityAccessor, class_2561> {
    public static final AnimalOwnerProvider INSTANCE = new AnimalOwnerProvider();

    @Override
    public @Nullable class_2561 streamData(EntityAccessor accessor) {
        class_1297 entity;
        class_3218 level = (class_3218)accessor.getLevel();
        UUID uuid = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
        class_1297 class_12972 = entity = uuid == null ? null : level.method_66347(uuid);
        if (entity != null) {
            return ObjectNameProvider.getEntityName(entity, false);
        }
        String name = AnimalOwnerProvider.lookupPlayerName(uuid, level.method_8503().method_73550());
        return name == null ? null : class_2561.method_43470((String)name);
    }

    @Override
    public class_9139<class_9129, class_2561> streamCodec() {
        return class_8824.field_48540;
    }

    public static @Nullable UUID getOwnerUUID(class_1297 entity) {
        class_6025 ownableEntity;
        class_10583 reference;
        if (entity instanceof class_6025 && (reference = (ownableEntity = (class_6025)entity).method_66287()) != null) {
            return reference.method_66263();
        }
        return null;
    }

    public static @Nullable String lookupPlayerName(@Nullable UUID uuid, class_7497 services) {
        if (uuid == null) {
            return null;
        }
        String name = services.comp_4407().method_14512(uuid).map(class_11560::comp_4423).orElse(null);
        if (name != null) {
            return name;
        }
        GameProfile profile = services.comp_4624().method_73290(uuid).orElse(null);
        return profile == null ? null : profile.name();
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        class_1297 entity = accessor.getEntity();
        return entity instanceof class_6025 && AnimalOwnerProvider.getOwnerUUID(entity) == null;
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_ANIMAL_OWNER;
    }

    public static class Client
    implements IEntityComponentProvider {
        public static final Client INSTANCE = new Client();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            class_2561 name = INSTANCE.decodeFromData(accessor).orElse(null);
            if (name == null) {
                UUID uuid = AnimalOwnerProvider.getOwnerUUID(accessor.getEntity());
                if (uuid == null) {
                    return;
                }
                name = class_2561.method_43470((String)Optional.ofNullable(ClientProxy.lookupPlayerName(uuid)).orElse("???"));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"jade.owner", (Object[])new Object[]{name}));
        }

        @Override
        public class_2960 getUid() {
            return JadeIds.MC_ANIMAL_OWNER;
        }
    }
}

